/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.LabelNotFoundKernelException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.core.NodeManager;

public class GlobalGraphOperations {
    private final NodeManager nodeManager;
    private final ThreadToStatementContextBridge statementCtxProvider;

    private GlobalGraphOperations(GraphDatabaseService db) {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        DependencyResolver resolver = dbApi.getDependencyResolver();
        this.nodeManager = resolver.resolveDependency(NodeManager.class);
        this.statementCtxProvider = resolver.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public static GlobalGraphOperations at(GraphDatabaseService db) {
        return new GlobalGraphOperations(db);
    }

    public Iterable<Node> getAllNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllNodes();
            }
        };
    }

    public Iterable<Relationship> getAllRelationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllRelationships();
            }
        };
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        return this.nodeManager.getRelationshipTypes();
    }

    public ResourceIterable<Node> getAllNodesWithLabel(final Label label) {
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                return GlobalGraphOperations.this.allNodesWithLabel(label.name());
            }
        };
    }

    private ResourceIterator<Node> allNodesWithLabel(String label) {
        StatementContext context = this.statementCtxProvider.getCtxForReading();
        try {
            long labelId = context.getLabelId(label);
            Iterator<Long> nodeIds = context.getNodesWithLabel(labelId);
            return IteratorUtil.withResource(Iterables.map(new Function<Long, Node>(){

                @Override
                public Node apply(Long nodeId) {
                    return GlobalGraphOperations.this.nodeManager.getNodeById(nodeId);
                }
            }, nodeIds), context);
        }
        catch (LabelNotFoundKernelException e) {
            context.close();
            return IteratorUtil.emptyIterator();
        }
    }
}

