/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyNodeStoreReader
implements Closeable {
    public static final String FROM_VERSION = "NodeStore v0.A.0";
    public static final int RECORD_LENGTH = 9;
    private final FileChannel fileChannel;
    private final long maxId;

    public LegacyNodeStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 9L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public Iterable<NodeRecord> readNodeStore() throws IOException {
        final ByteBuffer buffer = ByteBuffer.allocateDirect(9);
        return new Iterable<NodeRecord>(){

            @Override
            public Iterator<NodeRecord> iterator() {
                return new PrefetchingIterator<NodeRecord>(){
                    long id = 0L;

                    @Override
                    protected NodeRecord fetchNextOrNull() {
                        NodeRecord nodeRecord = null;
                        while (nodeRecord == null && this.id <= LegacyNodeStoreReader.this.maxId) {
                            boolean inUse;
                            buffer.clear();
                            try {
                                LegacyNodeStoreReader.this.fileChannel.read(buffer);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            buffer.flip();
                            long inUseByte = buffer.get();
                            boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
                            if (inUse) {
                                long nextRel = LegacyStore.getUnsignedInt(buffer);
                                long relModifier = (inUseByte & 0xEL) << 31;
                                long nextProp = LegacyStore.getUnsignedInt(buffer);
                                long propModifier = (inUseByte & 0xF0L) << 28;
                                nodeRecord = new NodeRecord(this.id, LegacyStore.longFromIntAndMod(nextRel, relModifier), LegacyStore.longFromIntAndMod(nextProp, propModifier));
                            } else {
                                nodeRecord = new NodeRecord(this.id, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
                            }
                            nodeRecord.setInUse(inUse);
                            ++this.id;
                        }
                        return nodeRecord;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

