/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.nioneo.store.AbstractSchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class IndexRule
extends AbstractSchemaRule {
    private final long propertyKey;

    public IndexRule(long id, long label, ByteBuffer serialized) {
        this(id, label, IndexRule.readPropertyKey(serialized));
    }

    public IndexRule(long id, long label, long propertyKey) {
        super(id, label, SchemaRule.Kind.INDEX_RULE);
        this.propertyKey = propertyKey;
    }

    private static long readPropertyKey(ByteBuffer serialized) {
        short count = serialized.getShort();
        assert (count == 1);
        return serialized.getLong();
    }

    public long getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public int length() {
        return super.length() + 2 + 8;
    }

    @Override
    public void serialize(ByteBuffer target) {
        super.serialize(target);
        target.putShort((short)1);
        target.putLong(this.propertyKey);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (int)this.propertyKey;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRule other = (IndexRule)obj;
        return this.propertyKey == other.propertyKey;
    }

    @Override
    protected String innerToString() {
        return ", properties=" + this.propertyKey;
    }
}

