/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractStore
extends CommonAbstractStore {
    private final Config conf;

    public abstract int getRecordSize();

    @Override
    protected long figureOutHighestIdInUse() {
        try {
            return this.getFileChannel().size() / (long)this.getRecordSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AbstractStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, conf, idType, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
        this.conf = conf;
    }

    @Override
    protected int getEffectiveRecordSize() {
        return this.getRecordSize();
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
    }

    @Override
    protected void verifyFileSizeAndTruncate() throws IOException {
        int expectedVersionLength = UTF8.encode(AbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor())).length;
        long fileSize = this.getFileChannel().size();
        if (this.getRecordSize() != 0 && (fileSize - (long)expectedVersionLength) % (long)this.getRecordSize() != 0L && !this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Misaligned file size " + fileSize + " for " + this + ", expected version length:" + expectedVersionLength));
        }
        if (this.getStoreOk() && !this.isReadOnly()) {
            this.getFileChannel().truncate(fileSize - (long)expectedVersionLength);
        }
    }

    public void setHighId(int id) {
        super.setHighId(id);
    }

    private long findHighIdBackwards() throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        int recordSize = this.getRecordSize();
        long fileSize = fileChannel.size();
        long highId = fileSize / (long)recordSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getRecordSize());
        for (long i = highId; i > 0L; --i) {
            fileChannel.position(i * (long)recordSize);
            if (fileChannel.read(byteBuffer) <= 0) continue;
            byteBuffer.flip();
            boolean isInUse = this.isRecordInUse(byteBuffer);
            byteBuffer.clear();
            if (!isInUse) continue;
            return i;
        }
        return 0L;
    }

    protected boolean isRecordInUse(ByteBuffer buffer) {
        byte inUse = buffer.get();
        return (inUse & 1) == Record.IN_USE.byteValue();
    }

    @Override
    protected void rebuildIdGenerator() {
        if (this.isReadOnly() && !this.isBackupSlave()) {
            throw new ReadOnlyDbException();
        }
        this.stringLogger.debug("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        if (this.fileSystemAbstraction.fileExists(new File(this.getStorageFileName().getPath() + ".id"))) {
            boolean success = this.fileSystemAbstraction.deleteFile(new File(this.getStorageFileName().getPath() + ".id"));
            assert (success);
        }
        this.createIdGenerator(new File(this.getStorageFileName().getPath() + ".id"));
        this.openIdGenerator(false);
        FileChannel fileChannel = this.getFileChannel();
        long highId = 1L;
        long defraggedCount = 0L;
        try {
            long fileSize = fileChannel.size();
            int recordSize = this.getRecordSize();
            boolean fullRebuild = true;
            if (this.conf.get(Configuration.rebuild_idgenerators_fast).booleanValue()) {
                fullRebuild = false;
                highId = this.findHighIdBackwards();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(recordSize);
            LinkedList<Long> freeIdList = new LinkedList<Long>();
            if (fullRebuild) {
                long i = 0L;
                while (i * (long)recordSize < fileSize && recordSize > 0) {
                    fileChannel.position(i * (long)recordSize);
                    byteBuffer.clear();
                    fileChannel.read(byteBuffer);
                    byteBuffer.flip();
                    if (!this.isRecordInUse(byteBuffer)) {
                        freeIdList.add(i);
                    } else {
                        highId = i;
                        this.setHighId(highId + 1L);
                        while (!freeIdList.isEmpty()) {
                            this.freeId((Long)freeIdList.removeFirst());
                            ++defraggedCount;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId + 1L);
        this.stringLogger.logMessage(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount, true);
        this.stringLogger.debug("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.closeIdGenerator();
        this.openIdGenerator(false);
    }

    public abstract List<WindowPoolStats> getAllWindowPoolStats();

    public void logAllWindowPoolStats(StringLogger.LineLogger logger) {
        logger.logLine(this.getWindowPoolStats().toString());
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
        public static final GraphDatabaseSetting.BooleanSetting rebuild_idgenerators_fast = GraphDatabaseSettings.rebuild_idgenerators_fast;
    }
}

