/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class TxState {
    private final Map<Long, NodeState> nodeStates = new HashMap<Long, NodeState>();
    private final Map<Long, LabelState> labelStates = new HashMap<Long, LabelState>();
    private final DiffSets<IndexRule> ruleDiffSets = new DiffSets();
    private final OldTxStateBridge legacyState;
    private final PersistenceManager legacyTransaction;
    private final IdGeneration idGeneration;
    private static final StateCreator<NodeState> NODE_STATE_CREATOR = new StateCreator<NodeState>(){

        @Override
        public NodeState newState(long id) {
            return new NodeState(id);
        }
    };
    private static final StateCreator<LabelState> LABEL_STATE_CREATOR = new StateCreator<LabelState>(){

        @Override
        public LabelState newState(long id) {
            return new LabelState(id);
        }
    };

    public TxState(OldTxStateBridge legacyState, PersistenceManager legacyTransaction, IdGeneration idGeneration) {
        this.legacyState = legacyState;
        this.legacyTransaction = legacyTransaction;
        this.idGeneration = idGeneration;
    }

    public boolean hasChanges() {
        return !this.nodeStates.isEmpty() || !this.labelStates.isEmpty();
    }

    public Iterable<NodeState> getNodeStates() {
        return this.nodeStates.values();
    }

    public DiffSets<Long> getLabelStateNodeDiffSets(long labelId) {
        return this.getState(this.labelStates, labelId, LABEL_STATE_CREATOR).getNodeDiffSets();
    }

    public DiffSets<Long> getNodeStateLabelDiffSets(long nodeId) {
        return this.getState(this.nodeStates, nodeId, NODE_STATE_CREATOR).getLabelDiffSets();
    }

    public void addLabelToNode(long labelId, long nodeId) {
        this.getLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getNodeStateLabelDiffSets(nodeId).add(labelId);
        this.legacyTransaction.addLabelToNode(labelId, nodeId);
    }

    public void removeLabelFromNode(long labelId, long nodeId) {
        this.getLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.legacyTransaction.removeLabelFromNode(labelId, nodeId);
    }

    public Boolean getLabelState(long nodeId, long labelId) {
        NodeState nodeState = this.getState(this.nodeStates, nodeId, null);
        if (nodeState != null) {
            DiffSets<Long> labelDiff = nodeState.getLabelDiffSets();
            if (labelDiff.isAdded(labelId)) {
                return Boolean.TRUE;
            }
            if (labelDiff.isRemoved(labelId)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Set<Long> getNodesWithLabelAdded(long labelId) {
        LabelState state = this.getState(this.labelStates, labelId, null);
        return state == null ? Collections.emptySet() : state.getNodeDiffSets().getAdded();
    }

    public Collection<Long> getNodesWithLabelRemoved(long labelId) {
        LabelState state = this.getState(this.labelStates, labelId, null);
        return state == null ? Collections.emptySet() : state.getNodeDiffSets().getRemoved();
    }

    public IndexRule addIndexRule(long labelId, long propertyKey) {
        IndexRule rule = new IndexRule(this.idGeneration.newSchemaRuleId(), labelId, propertyKey);
        this.legacyTransaction.createSchemaRule(rule);
        this.ruleDiffSets.add(rule);
        LabelState labelState = this.getState(this.labelStates, rule.getLabel(), LABEL_STATE_CREATOR);
        labelState.getIndexRuleDiffSets().add(rule);
        return rule;
    }

    public void dropIndexRule(IndexRule rule) {
        this.ruleDiffSets.remove(rule);
        LabelState labelState = this.getState(this.labelStates, rule.getLabel(), LABEL_STATE_CREATOR);
        labelState.getIndexRuleDiffSets().remove(rule);
        this.legacyTransaction.dropSchemaRule(rule.getId());
    }

    public DiffSets<IndexRule> getIndexRuleDiffSetsByLabel(long labelId) {
        LabelState labelState = this.getState(this.labelStates, labelId, null);
        return labelState != null ? labelState.getIndexRuleDiffSets() : DiffSets.emptyDiffSets();
    }

    public DiffSets<IndexRule> getIndexRuleDiffSets() {
        return this.ruleDiffSets;
    }

    public DiffSets<Long> getNodesWithChangedProperty(long propertyKeyId, Object value) {
        return this.legacyState.getNodesWithChangedProperty(propertyKeyId, value);
    }

    public Iterable<Long> getDeletedNodes() {
        return this.legacyState.getDeletedNodes();
    }

    private <STATE> STATE getState(Map<Long, STATE> states, long id, StateCreator<STATE> creator) {
        STATE result = states.get(id);
        if (result != null) {
            return result;
        }
        if (creator != null) {
            result = creator.newState(id);
            states.put(id, result);
        }
        return result;
    }

    public boolean haveIndexesBeenDropped() {
        return !this.getIndexRuleDiffSets().getRemoved().isEmpty();
    }

    public static class LabelState
    extends EntityState {
        private final DiffSets<Long> nodeDiffSets = new DiffSets();
        private final DiffSets<IndexRule> indexRuleDiffSets = new DiffSets();

        public LabelState(long id) {
            super(id);
        }

        public DiffSets<Long> getNodeDiffSets() {
            return this.nodeDiffSets;
        }

        public DiffSets<IndexRule> getIndexRuleDiffSets() {
            return this.indexRuleDiffSets;
        }
    }

    public static class NodeState
    extends EntityState {
        private final DiffSets<Long> labelDiffSets = new DiffSets();

        public NodeState(long id) {
            super(id);
        }

        public DiffSets<Long> getLabelDiffSets() {
            return this.labelDiffSets;
        }
    }

    public static class EntityState {
        private final long id;

        public EntityState(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }
    }

    private static interface StateCreator<STATE> {
        public STATE newState(long var1);
    }

    public static interface IdGeneration {
        public long newSchemaRuleId();
    }
}

