/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class OldTxStateBridgeImpl
implements OldTxStateBridge {
    private final TransactionState state;

    public OldTxStateBridgeImpl(TransactionState transactionState) {
        this.state = transactionState;
    }

    @Override
    public Iterable<Long> getDeletedNodes() {
        return this.state.getDeletedNodes();
    }

    @Override
    public DiffSets<Long> getNodesWithChangedProperty(long propertyKey, Object value) {
        DiffSets<Long> diff = new DiffSets<Long>();
        Iterable<WritableTransactionState.CowNodeElement> changedNodes = this.state.getChangedNodes();
        for (WritableTransactionState.CowNodeElement changedNode : changedNodes) {
            ArrayMap propAddMap;
            ArrayMap propRmMap = changedNode.getPropertyRemoveMap(false);
            if (propRmMap != null) {
                for (PropertyData propertyData : propRmMap.values()) {
                    if ((long)propertyData.getIndex() != propertyKey || !propertyData.getValue().equals(value)) continue;
                    diff.remove(changedNode.getId());
                }
            }
            if (changedNode.isDeleted() || (propAddMap = changedNode.getPropertyAddMap(false)) == null) continue;
            for (PropertyData propertyData : propAddMap.values()) {
                if ((long)propertyData.getIndex() != propertyKey) continue;
                if (propertyData.getValue().equals(value)) {
                    diff.add(changedNode.getId());
                    continue;
                }
                diff.remove(changedNode.getId());
            }
        }
        return diff;
    }
}

