/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;

public class IndexRuleRepository {
    private final Map<Long, Set<Long>> indexedProperties = new HashMap<Long, Set<Long>>();

    public Iterator<Long> getIndexedProperties(long labelId) {
        return this.indexedProperties.containsKey(labelId) ? this.indexedProperties.get(labelId).iterator() : Collections.emptyList().iterator();
    }

    public void add(IndexRule rule) {
        if (!this.indexedProperties.containsKey(rule.getLabel())) {
            this.indexedProperties.put(rule.getLabel(), new HashSet());
        }
        this.indexedProperties.get(rule.getLabel()).add(rule.getPropertyKey());
    }

    public void remove(IndexRule rule) {
        if (this.indexedProperties.containsKey(rule.getLabel())) {
            this.indexedProperties.get(rule.getLabel()).remove(rule.getPropertyKey());
        }
    }
}

