/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.EntityNotFoundException;
import org.neo4j.kernel.api.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.PropertyNotFoundException;
import org.neo4j.kernel.api.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.SchemaOperations;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;

public class TransactionStateStatementContext
extends CompositeStatementContext {
    private final TxState state;
    private final StatementContext delegate;
    private final SchemaOperations schemaOperations;

    public TransactionStateStatementContext(StatementContext actual, SchemaOperations schemaOperations, TxState state) {
        super(actual, schemaOperations);
        this.state = state;
        this.delegate = actual;
        this.schemaOperations = schemaOperations;
    }

    public TransactionStateStatementContext(StatementContext actual, TxState state) {
        this(actual, actual, state);
    }

    @Override
    public Object getNodePropertyValue(long nodeId, long propertyId) throws PropertyNotFoundException, PropertyKeyIdNotFoundException {
        throw new UnsupportedOperationException("only implemented in StoreStatementContext for now");
    }

    @Override
    public boolean isLabelSetOnNode(long labelId, long nodeId) {
        Boolean labelState;
        if (this.state.hasChanges() && (labelState = this.state.getLabelState(nodeId, labelId)) != null) {
            return labelState;
        }
        return this.delegate.isLabelSetOnNode(labelId, nodeId);
    }

    @Override
    public Iterator<Long> getLabelsForNode(long nodeId) {
        Iterator<Long> committed = this.delegate.getLabelsForNode(nodeId);
        return this.state.getNodeStateLabelDiffSets(nodeId).apply(committed);
    }

    @Override
    public boolean addLabelToNode(long labelId, long nodeId) {
        if (this.isLabelSetOnNode(labelId, nodeId)) {
            return false;
        }
        this.state.addLabelToNode(labelId, nodeId);
        return true;
    }

    @Override
    public boolean removeLabelFromNode(long labelId, long nodeId) {
        if (!this.isLabelSetOnNode(labelId, nodeId)) {
            return false;
        }
        this.state.removeLabelFromNode(labelId, nodeId);
        return true;
    }

    @Override
    public Iterator<Long> getNodesWithLabel(long labelId) {
        Iterator<Long> committed = this.delegate.getNodesWithLabel(labelId);
        if (!this.state.hasChanges()) {
            return committed;
        }
        Iterator<Long> result = committed;
        final Collection<Long> removed = this.state.getNodesWithLabelRemoved(labelId);
        if (!removed.isEmpty()) {
            result = Iterables.filter(new Predicate<Long>(){

                @Override
                public boolean accept(Long item) {
                    return !removed.contains(item);
                }
            }, result);
        }
        Set<Long> added = this.state.getNodesWithLabelAdded(labelId);
        return Iterables.concat(result, added.iterator());
    }

    @Override
    public IndexRule addIndexRule(long labelId, long propertyKey) throws ConstraintViolationKernelException {
        return this.state.addIndexRule(labelId, propertyKey);
    }

    @Override
    public void dropIndexRule(IndexRule indexRule) throws ConstraintViolationKernelException {
        this.state.dropIndexRule(indexRule);
    }

    @Override
    public IndexRule getIndexRule(long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        Iterable<Object> committedRules;
        try {
            committedRules = Iterables.option(this.schemaOperations.getIndexRule(labelId, propertyKey));
        }
        catch (SchemaRuleNotFoundException e) {
            committedRules = Collections.emptyList();
        }
        DiffSets<IndexRule> ruleDiffSet = this.state.getIndexRuleDiffSetsByLabel(labelId);
        Iterator<Object> rules = ruleDiffSet.apply(committedRules.iterator());
        IndexRule single = (IndexRule)IteratorUtil.singleOrNull(rules);
        if (single == null) {
            throw new SchemaRuleNotFoundException("Index rule for label:" + labelId + " and property:" + propertyKey + " not found");
        }
        return single;
    }

    @Override
    public InternalIndexState getIndexState(IndexRule indexRule) throws IndexNotFoundKernelException {
        DiffSets<IndexRule> diffSet = this.state.getIndexRuleDiffSetsByLabel(indexRule.getLabel());
        if (diffSet.isAdded(indexRule)) {
            return InternalIndexState.POPULATING;
        }
        if (diffSet.isRemoved(indexRule)) {
            throw new IndexNotFoundKernelException(String.format("Index for label id %d on property id %d has been dropped in this transaction.", indexRule.getLabel(), indexRule.getPropertyKey()));
        }
        return this.delegate.getIndexState(indexRule);
    }

    @Override
    public Iterator<IndexRule> getIndexRules(long labelId) {
        return this.state.getIndexRuleDiffSetsByLabel(labelId).apply(this.delegate.getIndexRules(labelId));
    }

    @Override
    public Iterator<IndexRule> getIndexRules() {
        return this.state.getIndexRuleDiffSets().apply(this.delegate.getIndexRules());
    }

    @Override
    public Iterator<Long> exactIndexLookup(long indexId, Object value) throws IndexNotFoundKernelException {
        IndexDescriptor idx = this.delegate.getIndexDescriptor(indexId);
        DiffSets<Long> diff = this.state.getNodesWithChangedProperty(idx.getPropertyKeyId(), value);
        diff.removeAll(this.state.getDeletedNodes());
        diff = diff.filterAdded(new HasLabelFilter(idx.getLabelId()));
        HasPropertyFilter hasPropertyFilter = new HasPropertyFilter(idx.getPropertyKeyId(), value);
        Set<Long> addedNodesWithLabel = this.state.getNodesWithLabelAdded(idx.getLabelId());
        diff.addAll(Iterables.filter(hasPropertyFilter, addedNodesWithLabel));
        Collection<Long> removedNodesWithLabel = this.state.getNodesWithLabelRemoved(idx.getLabelId());
        diff.removeAll(Iterables.filter(hasPropertyFilter, removedNodesWithLabel));
        return diff.apply(this.delegate.exactIndexLookup(indexId, value));
    }

    private class HasLabelFilter
    implements Predicate<Long> {
        private final long labelId;

        public HasLabelFilter(long labelId) {
            this.labelId = labelId;
        }

        @Override
        public boolean accept(Long nodeId) {
            return TransactionStateStatementContext.this.isLabelSetOnNode(this.labelId, nodeId);
        }
    }

    private class HasPropertyFilter
    implements Predicate<Long> {
        private final Object value;
        private final long propertyKeyId;

        public HasPropertyFilter(long propertyKeyId, Object value) {
            this.value = value;
            this.propertyKeyId = propertyKeyId;
        }

        @Override
        public boolean accept(Long nodeId) {
            try {
                return this.value.equals(TransactionStateStatementContext.this.delegate.getNodePropertyValue(nodeId, this.propertyKeyId));
            }
            catch (PropertyNotFoundException e) {
                return false;
            }
            catch (EntityNotFoundException e) {
                return false;
            }
            catch (PropertyKeyIdNotFoundException e) {
                throw new ThisShouldNotHappenError("Stefan/Jake", "propertyKeyId became invalid during indexQuery");
            }
        }
    }
}

