/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.api.InteractionStoppingStatementContext;

public abstract class StatementContextOwner {
    private StatementContext statementContext;
    public int count;

    public StatementContext getStatementContext() {
        if (this.statementContext == null) {
            this.statementContext = this.createStatementContext();
        }
        ++this.count;
        return new StatementContextReference(this.statementContext);
    }

    protected abstract StatementContext createStatementContext();

    public void closeAllStatements() {
        if (this.statementContext != null) {
            this.statementContext.close();
            this.statementContext = null;
        }
        this.count = 0;
    }

    private class StatementContextReference
    extends InteractionStoppingStatementContext {
        public StatementContextReference(StatementContext delegate) {
            super(delegate);
        }

        @Override
        public void close() {
            this.markAsClosed();
            --StatementContextOwner.this.count;
            if (StatementContextOwner.this.count == 0) {
                StatementContextOwner.this.statementContext.close();
                StatementContextOwner.this.statementContext = null;
            }
            if (StatementContextOwner.this.count < 0) {
                throw new IllegalStateException("Lost track of at least one StatementContext");
            }
        }
    }
}

