/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.TransactionContext;
import org.neo4j.kernel.impl.api.DelegatingTransactionContext;
import org.neo4j.kernel.impl.api.InteractionStoppingStatementContext;

public class SingleStatementTransactionContext
extends DelegatingTransactionContext {
    private InteractionStoppingStatementContext activeStatement;
    private boolean finished;

    public SingleStatementTransactionContext(TransactionContext delegate) {
        super(delegate);
    }

    @Override
    public StatementContext newStatementContext() {
        this.assertNewStatementAllowed();
        StatementContext inner = super.newStatementContext();
        this.activeStatement = new InteractionStoppingStatementContext(inner);
        return this.activeStatement;
    }

    @Override
    public void prepare() {
        this.closeShop();
        super.prepare();
    }

    @Override
    public void commit() {
        this.closeShop();
        super.commit();
    }

    @Override
    public void rollback() {
        this.closeShop();
        super.rollback();
    }

    private void closeShop() {
        if (this.anyActiveStatement()) {
            throw new IllegalStateException("Cannot commit, prepare or roll back since there is still an active statement.");
        }
        this.finished = true;
    }

    private void assertNewStatementAllowed() {
        if (this.finished) {
            throw new IllegalStateException("This TransactionContext is finished. No new statements allowed");
        }
        if (this.anyActiveStatement()) {
            throw new IllegalStateException("There is an active StatementContext. No new statements allowed");
        }
    }

    private boolean anyActiveStatement() {
        return this.activeStatement != null && this.activeStatement.isOpen();
    }
}

