/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.collection.NestingIterable;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class SchemaCache {
    private final Map<Long, Map<Long, SchemaRule>> rulesMap = new HashMap<Long, Map<Long, SchemaRule>>();
    private final Map<Long, SchemaRule> ruleByIdMap = new HashMap<Long, SchemaRule>();

    public SchemaCache(Iterable<SchemaRule> initialRules) {
        this.splitUpInitialRules(initialRules);
    }

    private void splitUpInitialRules(Iterable<SchemaRule> initialRules) {
        for (SchemaRule rule : initialRules) {
            this.addSchemaRule(rule);
        }
    }

    private Map<Long, SchemaRule> getOrCreateSchemaRulesMapForLabel(Long label) {
        Map<Long, SchemaRule> rulesForLabel = this.rulesMap.get(label);
        if (rulesForLabel == null) {
            rulesForLabel = new HashMap<Long, SchemaRule>();
            this.rulesMap.put(label, rulesForLabel);
        }
        return rulesForLabel;
    }

    public Iterable<SchemaRule> getSchemaRules() {
        return new NestingIterable<SchemaRule, Map<Long, SchemaRule>>(this.rulesMap.values()){

            @Override
            protected Iterator<SchemaRule> createNestedIterator(Map<Long, SchemaRule> item) {
                return item.values().iterator();
            }
        };
    }

    public Collection<SchemaRule> getSchemaRules(long label) {
        Map<Long, SchemaRule> rulesForLabel = this.rulesMap.get(label);
        return rulesForLabel != null ? Collections.unmodifiableCollection(rulesForLabel.values()) : Collections.emptyList();
    }

    public void addSchemaRule(SchemaRule rule) {
        this.getOrCreateSchemaRulesMapForLabel(rule.getLabel()).put(rule.getId(), rule);
        this.ruleByIdMap.put(rule.getId(), rule);
    }

    public void removeSchemaRule(long id) {
        SchemaRule rule = this.ruleByIdMap.remove(id);
        if (rule == null) {
            return;
        }
        Map<Long, SchemaRule> rules = this.rulesMap.get(rule.getLabel());
        if (rules.remove(id) != null && rules.isEmpty()) {
            this.rulesMap.remove(rule.getLabel());
        }
    }
}

