/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.cache.LockStripedCache;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;

class NodeCacheLoader
implements LockStripedCache.Loader<PersistenceCache.CachedNodeEntity> {
    private final NodeStore nodeStore;

    NodeCacheLoader(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    @Override
    public PersistenceCache.CachedNodeEntity loadById(long id) {
        try {
            PersistenceCache.CachedNodeEntity result = new PersistenceCache.CachedNodeEntity(id);
            result.addLabels(IteratorUtil.asSet(IteratorUtil.asIterable(this.nodeStore.getLabelsForNode(this.nodeStore.getRecord(id)))));
            return result;
        }
        catch (InvalidRecordException e) {
            return null;
        }
    }
}

