/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;

public class DiffSets<T> {
    private static final DiffSets EMPTY = new DiffSets(Collections.emptySet(), Collections.emptySet()){

        public Iterator apply(Iterator source) {
            return source;
        }
    };
    private Set<T> addedElements;
    private Set<T> removedElements;
    private Predicate<T> filter;

    public static <T> DiffSets<T> emptyDiffSets() {
        return EMPTY;
    }

    public static <E> DiffSets<E> fromAdding(E ... elems) {
        HashSet addedElements = new HashSet(elems.length);
        Collections.addAll(addedElements, elems);
        return new DiffSets(addedElements, null);
    }

    public DiffSets() {
        this(null, null);
    }

    public DiffSets(Set<T> addedElements, Set<T> removedElements) {
        this.addedElements = addedElements;
        this.removedElements = removedElements;
    }

    public boolean add(T elem) {
        this.ensureAddedHasBeenCreated();
        boolean result = this.addedElements.add(elem);
        if (this.removedElements != null) {
            this.removedElements.remove(elem);
        }
        return result;
    }

    public boolean remove(T elem) {
        this.ensureRemoveHasBeenCreated();
        boolean removedFromAddedElements = false;
        if (this.addedElements != null) {
            removedFromAddedElements = this.addedElements.remove(elem);
        }
        boolean result = removedFromAddedElements || this.removedElements.add(elem);
        return result;
    }

    public void addAll(Iterable<T> elems) {
        for (T elem : elems) {
            this.add(elem);
        }
    }

    public void removeAll(Iterable<T> elems) {
        for (T elem : elems) {
            this.remove(elem);
        }
    }

    public boolean isAdded(T elem) {
        return this.addedElements != null && this.addedElements.contains(elem);
    }

    public boolean isRemoved(T elem) {
        return this.removedElements != null && this.removedElements.contains(elem);
    }

    public Set<T> getAdded() {
        return this.resultSet(this.addedElements);
    }

    public Set<T> getRemoved() {
        return this.resultSet(this.removedElements);
    }

    public boolean isEmpty() {
        return this.getAdded().isEmpty() && this.getRemoved().isEmpty();
    }

    private void ensureAddedHasBeenCreated() {
        if (this.addedElements == null) {
            this.addedElements = this.newSet();
        }
    }

    private void ensureRemoveHasBeenCreated() {
        if (this.removedElements == null) {
            this.removedElements = this.newSet();
            this.ensureFilterHasBeenCreated();
        }
    }

    private void ensureFilterHasBeenCreated() {
        if (this.filter == null) {
            this.filter = new Predicate<T>(){

                @Override
                public boolean accept(T item) {
                    return !DiffSets.this.removedElements.contains(item);
                }
            };
        }
    }

    private Set<T> newSet() {
        return new HashSet();
    }

    private Set<T> resultSet(Set<T> coll) {
        return coll == null ? Collections.emptySet() : Collections.unmodifiableSet(coll);
    }

    public Iterator<T> apply(Iterator<T> source) {
        Iterator<T> result = source;
        if (this.removedElements != null && !this.removedElements.isEmpty()) {
            this.ensureFilterHasBeenCreated();
            result = Iterables.filter(this.filter, result);
        }
        if (this.addedElements != null && !this.addedElements.isEmpty()) {
            result = Iterables.concat(result, this.addedElements.iterator());
        }
        return result;
    }

    public DiffSets<T> filterAdded(Predicate<T> addedFilter) {
        Iterable<T> newAdded = Iterables.filter(addedFilter, this.getAdded());
        Set<T> newRemoved = this.getRemoved();
        return new DiffSets<T>(IteratorUtil.asSet(newAdded), IteratorUtil.asSet(newRemoved));
    }
}

