/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.guard;

import org.neo4j.kernel.guard.GuardOperationsCountException;
import org.neo4j.kernel.guard.GuardTimeoutException;
import org.neo4j.kernel.impl.util.StringLogger;

public class Guard {
    private final ThreadLocal<GuardInternal> threadLocal = new ThreadLocal();
    private final StringLogger logger;

    public Guard(StringLogger logger) {
        this.logger = logger;
    }

    public void check() {
        Object guardInternal = this.currentGuard();
        if (guardInternal != null) {
            guardInternal.check();
        }
    }

    public <T extends GuardInternal> T currentGuard() {
        return (T)this.threadLocal.get();
    }

    public void startOperationsCount(long maxOps) {
        this.start(new OperationsCount(maxOps));
    }

    public void startTimeout(long validFor) {
        Timeout timeout = new Timeout(validFor + System.currentTimeMillis());
        this.start(timeout);
    }

    public void start(GuardInternal guard) {
        this.threadLocal.set(guard);
    }

    public <T extends GuardInternal> T stop() {
        T guardInternal = this.currentGuard();
        if (guardInternal != null) {
            this.threadLocal.remove();
        }
        return guardInternal;
    }

    public class Timeout
    implements GuardInternal {
        private final long valid;
        private final long start;

        private Timeout(long valid) {
            this.valid = valid;
            this.start = System.currentTimeMillis();
        }

        @Override
        public void check() {
            if (this.valid < System.currentTimeMillis()) {
                long overtime = System.currentTimeMillis() - this.valid;
                Guard.this.logger.logMessage("guard-timeout:" + (this.valid - this.start) + "(+" + overtime + ")ms");
                throw new GuardTimeoutException(overtime);
            }
        }
    }

    public class OperationsCount
    implements GuardInternal {
        private final long max;
        private long opsCount = 0L;

        private OperationsCount(long max) {
            this.max = max;
        }

        @Override
        public void check() {
            ++this.opsCount;
            if (this.max < this.opsCount) {
                Guard.this.logger.logMessage("guard-timeout: node-ops: more than " + this.max);
                throw new GuardOperationsCountException(this.opsCount);
            }
        }

        public long getOpsCount() {
            return this.opsCount;
        }
    }

    public static interface GuardInternal {
        public void check();
    }
}

