/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.IndexCreatorImpl;
import org.neo4j.kernel.IndexDefinitionImpl;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.LabelNotFoundKernelException;
import org.neo4j.kernel.api.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.core.KeyHolder;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;

public class SchemaImpl
implements Schema {
    private final ThreadToStatementContextBridge ctxProvider;
    private final KeyHolder<PropertyIndex> propertyKeyManager;

    public SchemaImpl(ThreadToStatementContextBridge ctxProvider, KeyHolder<PropertyIndex> propertyKeyManager) {
        this.ctxProvider = ctxProvider;
        this.propertyKeyManager = propertyKeyManager;
    }

    @Override
    public IndexCreator indexCreator(Label label) {
        return new IndexCreatorImpl(this.ctxProvider, this.propertyKeyManager, label);
    }

    @Override
    public ResourceIterable<IndexDefinition> getIndexes(final Label label) {
        return new ResourceIterable<IndexDefinition>(){

            @Override
            public ResourceIterator<IndexDefinition> iterator() {
                StatementContext context = SchemaImpl.this.ctxProvider.getCtxForReading();
                try {
                    return SchemaImpl.this.getIndexDefinitions(context, context.getIndexRules(context.getLabelId(label.name())));
                }
                catch (LabelNotFoundKernelException e) {
                    context.close();
                    return IteratorUtil.emptyIterator();
                }
            }
        };
    }

    @Override
    public ResourceIterable<IndexDefinition> getIndexes() {
        return new ResourceIterable<IndexDefinition>(){

            @Override
            public ResourceIterator<IndexDefinition> iterator() {
                StatementContext context = SchemaImpl.this.ctxProvider.getCtxForReading();
                return SchemaImpl.this.getIndexDefinitions(context, context.getIndexRules());
            }
        };
    }

    private ResourceIterator<IndexDefinition> getIndexDefinitions(final StatementContext context, Iterator<IndexRule> indexRules) {
        return IteratorUtil.withResource(Iterables.map(new Function<IndexRule, IndexDefinition>(){

            @Override
            public IndexDefinition apply(IndexRule rule) {
                try {
                    return new IndexDefinitionImpl(SchemaImpl.this.ctxProvider, DynamicLabel.label(context.getLabelName(rule.getLabel())), ((PropertyIndex)SchemaImpl.this.propertyKeyManager.getKeyByIdOrNull((int)rule.getPropertyKey())).getKey());
                }
                catch (LabelNotFoundKernelException e) {
                    throw new RuntimeException(e);
                }
            }
        }, indexRules), context);
    }

    @Override
    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        long now = System.currentTimeMillis();
        long timeout = now + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            Thread.yield();
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    @Override
    public Schema.IndexState getIndexState(IndexDefinition index) {
        StatementContext context = this.ctxProvider.getCtxForReading();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try {
            long labelId = context.getLabelId(index.getLabel().name());
            long propertyKeyId = context.getPropertyKeyId(propertyKey);
            InternalIndexState indexState = context.getIndexState(context.getIndexRule(labelId, propertyKeyId));
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            try {
                throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
            }
            catch (LabelNotFoundKernelException e) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            catch (PropertyKeyNotFoundException e) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            catch (SchemaRuleNotFoundException e) {
                throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
            }
            catch (IndexNotFoundKernelException e) {
                throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey), e);
            }
        }
        finally {
            context.close();
        }
    }
}

