/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.helpers.ValueGetter;

public abstract class FutureAdapter<V>
implements Future<V> {
    public static final Future<Void> VOID = new Present<Object>(null);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    public static <T> Future<T> latchGuardedValue(final ValueGetter<T> value, final CountDownLatch guardedByLatch) {
        return new FutureAdapter<T>(){

            @Override
            public boolean isDone() {
                return guardedByLatch.getCount() == 0L;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                guardedByLatch.await();
                return value.get();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (!guardedByLatch.await(timeout, unit)) {
                    throw new TimeoutException("Index population job cancel didn't complete within " + timeout + " " + (Object)((Object)unit));
                }
                return value.get();
            }
        };
    }

    public static <T> Future<T> future(Callable<T> task) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(task);
        executor.shutdown();
        return future;
    }

    public static class Present<V>
    extends FutureAdapter<V> {
        private final V value;

        public Present(V value) {
            this.value = value;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            return this.value;
        }
    }
}

