/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

public abstract class LogBackedXaDataSource
extends XaDataSource {
    private XaLogicalLog logicalLog;

    public LogBackedXaDataSource(byte[] branchId, String name) {
        super(branchId, name);
    }

    protected void setLogicalLogAtCreationTime(XaLogicalLog logicalLog) {
        if (this.logicalLog != null) {
            throw new RuntimeException("Logical log already set for " + this);
        }
        this.logicalLog = logicalLog;
    }

    @Override
    public void stop() {
        if (this.logicalLog == null) {
            return;
        }
        try {
            this.logicalLog.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logicalLog = null;
    }

    @Override
    public boolean deleteLogicalLog(long version) {
        return this.logicalLog.deleteLogicalLog(version);
    }

    @Override
    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.logicalLog.getLogicalLogOrMyselfCommitted(version, 0L);
    }

    @Override
    public long getLogicalLogLength(long version) {
        return this.logicalLog.getLogicalLogLength(version);
    }

    @Override
    public boolean hasLogicalLog(long version) {
        return this.logicalLog.hasLogicalLog(version);
    }

    @Override
    public long rotateLogicalLog() throws IOException {
        return this.getXaContainer().getResourceManager().rotateLogicalLog();
    }

    @Override
    public void setAutoRotate(boolean rotate) {
        this.logicalLog.setAutoRotateLogs(rotate);
    }

    @Override
    public void setLogicalLogTargetSize(long size) {
        this.logicalLog.setLogicalLogTargetSize(size);
    }

    @Override
    public File getFileName(long version) {
        return this.logicalLog.getFileName(version);
    }

    @Override
    public ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        return this.logicalLog.getPreparedTransaction(identifier);
    }

    @Override
    public void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        this.logicalLog.getPreparedTransaction(identifier, targetBuffer);
    }

    @Override
    public Pair<Integer, Long> getMasterForCommittedTx(long txId) throws IOException {
        return this.logicalLog.getMasterForCommittedTransaction(txId);
    }

    @Override
    public LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
        return this.logicalLog.getLogExtractor(startTxId, endTxIdHint);
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting.StringSetting keep_logical_logs = GraphDatabaseSettings.keep_logical_logs;
    }
}

