/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.kernel.impl.util.RelIdArray;

public class RelIdArrayWithLoops
extends RelIdArray {
    private RelIdArray.IdBlock lastLoopBlock;

    public RelIdArrayWithLoops(int type) {
        super(type);
    }

    @Override
    public int size() {
        return super.size() + RelIdArrayWithLoops.sizeOfBlockWithReference(this.lastLoopBlock);
    }

    protected RelIdArrayWithLoops(RelIdArray from) {
        super(from);
        this.lastLoopBlock = from.getLastLoopBlock();
    }

    protected RelIdArrayWithLoops(int type, RelIdArray.IdBlock out, RelIdArray.IdBlock in, RelIdArray.IdBlock loop) {
        super(type, out, in);
        this.lastLoopBlock = loop;
    }

    @Override
    protected RelIdArray.IdBlock getLastLoopBlock() {
        return this.lastLoopBlock;
    }

    @Override
    protected void setLastLoopBlock(RelIdArray.IdBlock block) {
        this.lastLoopBlock = block;
    }

    @Override
    public RelIdArray upgradeIfNeeded(RelIdArray capabilitiesToMatch) {
        return this;
    }

    @Override
    public RelIdArray downgradeIfPossible() {
        return this.lastLoopBlock == null ? new RelIdArray(this) : this;
    }

    @Override
    public RelIdArray addAll(RelIdArray source) {
        if (source == null) {
            return this;
        }
        this.append(source, RelIdArray.DirectionWrapper.OUTGOING);
        this.append(source, RelIdArray.DirectionWrapper.INCOMING);
        this.append(source, RelIdArray.DirectionWrapper.BOTH);
        return this;
    }

    @Override
    public RelIdArray newSimilarInstance() {
        return new RelIdArrayWithLoops(this.getType());
    }

    @Override
    public boolean couldBeNeedingUpdate() {
        return true;
    }

    @Override
    public RelIdArray shrink() {
        RelIdArray.IdBlock lastOutBlock = RelIdArray.DirectionWrapper.OUTGOING.getLastBlock(this);
        RelIdArray.IdBlock lastInBlock = RelIdArray.DirectionWrapper.INCOMING.getLastBlock(this);
        RelIdArray.IdBlock shrunkOut = lastOutBlock != null ? lastOutBlock.shrink() : null;
        RelIdArray.IdBlock shrunkIn = lastInBlock != null ? lastInBlock.shrink() : null;
        RelIdArray.IdBlock shrunkLoop = this.lastLoopBlock != null ? this.lastLoopBlock.shrink() : null;
        return shrunkOut == lastOutBlock && shrunkIn == lastInBlock && shrunkLoop == this.lastLoopBlock ? this : new RelIdArrayWithLoops(this.getType(), shrunkOut, shrunkIn, shrunkLoop);
    }
}

