/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;

public class CompareTxStreams {
    public static void main(String[] args) throws IOException {
        CompareTxStreams.compareLogStreams(LogExtractor.from(new File(args[0])), LogExtractor.from(new File(args[1])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void compareLogStreams(LogExtractor extractor1, LogExtractor extractor2) throws IOException {
        try {
            boolean branchingDetected = false;
            long lastTx = 1L;
            while (true) {
                long tx2;
                long tx1;
                if ((tx1 = extractor1.extractNext(new InMemoryLogBuffer())) != (tx2 = extractor2.extractNext(new InMemoryLogBuffer()))) {
                    throw new RuntimeException("Differing tx " + tx1 + " and " + tx2);
                }
                if (tx1 == -1L || tx2 == -1L) break;
                lastTx = tx1;
                if (!branchingDetected) {
                    if (extractor1.getLastStartEntry().getMasterId() == extractor2.getLastStartEntry().getMasterId() && extractor1.getLastTxChecksum() == extractor2.getLastTxChecksum()) continue;
                    branchingDetected = true;
                    System.out.println("Branch at " + tx1 + ": masters:" + extractor1.getLastStartEntry().getMasterId() + "," + extractor2.getLastStartEntry().getMasterId() + " checksums:" + extractor1.getLastTxChecksum() + "," + extractor2.getLastTxChecksum());
                    continue;
                }
                if (extractor1.getLastStartEntry().getMasterId() == extractor2.getLastStartEntry().getMasterId() && extractor1.getLastTxChecksum() == extractor2.getLastTxChecksum()) {
                    branchingDetected = false;
                    System.out.println("Merged again at " + tx1);
                    continue;
                }
                System.out.println("Still branched at " + tx1 + ": masters:" + extractor1.getLastStartEntry().getMasterId() + "," + extractor2.getLastStartEntry().getMasterId() + " checksums:" + extractor1.getLastTxChecksum() + "," + extractor2.getLastTxChecksum());
            }
            System.out.println("Last tx " + lastTx);
        }
        finally {
            CompareTxStreams.closeExtractor(extractor1);
            CompareTxStreams.closeExtractor(extractor2);
        }
    }

    private static void closeExtractor(LogExtractor extractor) {
        if (extractor != null) {
            extractor.close();
        }
    }
}

