/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyType;
import org.neo4j.kernel.impl.util.StringLogger;

public class LegacyDynamicRecordFetcher {
    private LegacyDynamicStoreReader stringPropertyStore;
    private LegacyDynamicStoreReader arrayPropertyStore;

    public LegacyDynamicRecordFetcher(File stringStoreFileName, File arrayStoreFileName) throws IOException {
        this(stringStoreFileName, arrayStoreFileName, StringLogger.DEV_NULL);
    }

    public LegacyDynamicRecordFetcher(File stringStoreFileName, File arrayStoreFileName, StringLogger log) throws IOException {
        this.stringPropertyStore = new LegacyDynamicStoreReader(stringStoreFileName, "StringPropertyStore v0.9.9", log);
        this.arrayPropertyStore = new LegacyDynamicStoreReader(arrayStoreFileName, "ArrayPropertyStore v0.9.9", log);
    }

    public List<LegacyDynamicRecord> readDynamicRecords(LegacyPropertyRecord record) {
        if (record.getType() == LegacyPropertyType.STRING) {
            List<LegacyDynamicRecord> stringRecords = this.stringPropertyStore.getPropertyChain(record.getPropBlock());
            for (LegacyDynamicRecord stringRecord : stringRecords) {
                stringRecord.setType(PropertyType.STRING.intValue());
            }
            return stringRecords;
        }
        if (record.getType() == LegacyPropertyType.ARRAY) {
            List<LegacyDynamicRecord> arrayRecords = this.arrayPropertyStore.getPropertyChain(record.getPropBlock());
            for (LegacyDynamicRecord arrayRecord : arrayRecords) {
                arrayRecord.setType(PropertyType.ARRAY.intValue());
            }
            return arrayRecords;
        }
        return null;
    }

    public Object getStringFor(LegacyPropertyRecord propRecord) {
        long startRecordId = propRecord.getPropBlock();
        List<LegacyDynamicRecord> legacyDynamicRecords = this.readDynamicRecords(propRecord);
        return LegacyDynamicRecordFetcher.joinRecordsIntoString(startRecordId, legacyDynamicRecords);
    }

    public static String joinRecordsIntoString(long startRecordId, List<LegacyDynamicRecord> legacyDynamicRecords) {
        HashMap<Long, LegacyDynamicRecord> recordsMap = new HashMap<Long, LegacyDynamicRecord>();
        long recordToFind = startRecordId;
        for (LegacyDynamicRecord record : legacyDynamicRecords) {
            recordsMap.put(record.getId(), record);
        }
        LinkedList<char[]> charList = new LinkedList<char[]>();
        while (recordToFind != (long)Record.NO_NEXT_BLOCK.intValue()) {
            LegacyDynamicRecord record;
            record = (LegacyDynamicRecord)recordsMap.get(recordToFind);
            if (!record.isCharData()) {
                ByteBuffer buf = ByteBuffer.wrap(record.getData());
                char[] chars = new char[record.getData().length / 2];
                buf.asCharBuffer().get(chars);
                charList.add(chars);
            } else {
                charList.add(record.getDataAsChar());
            }
            recordToFind = record.getNextBlock();
        }
        StringBuffer buf = new StringBuffer();
        for (char[] str : charList) {
            buf.append(str);
        }
        return buf.toString();
    }

    public Object getArrayFor(LegacyPropertyRecord propertyRecord) {
        long recordToFind = propertyRecord.getPropBlock();
        HashMap<Long, LegacyDynamicRecord> recordsMap = new HashMap<Long, LegacyDynamicRecord>();
        for (LegacyDynamicRecord record : this.readDynamicRecords(propertyRecord)) {
            recordsMap.put(record.getId(), record);
        }
        LinkedList<byte[]> byteList = new LinkedList<byte[]>();
        int totalSize = 0;
        while (recordToFind != (long)Record.NO_NEXT_BLOCK.intValue()) {
            byte[] bytes;
            ByteBuffer buf;
            LegacyDynamicRecord record = (LegacyDynamicRecord)recordsMap.get(recordToFind);
            if (!record.isCharData()) {
                buf = ByteBuffer.wrap(record.getData());
                bytes = new byte[record.getData().length];
                totalSize += bytes.length;
            } else {
                throw new InvalidRecordException("Expected byte data on record " + record);
            }
            buf.get(bytes);
            byteList.add(bytes);
            recordToFind = record.getNextBlock();
        }
        byte[] bArray = new byte[totalSize];
        int offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, 0, bArray, offset, currentArray.length);
            offset += currentArray.length;
        }
        return LegacyDynamicStoreReader.getRightArray(bArray);
    }

    public void close() throws IOException {
        this.arrayPropertyStore.close();
        this.stringPropertyStore.close();
    }
}

