/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.NoSuchElementException;
import org.neo4j.helpers.Service;

public class Version
extends Service {
    protected static final String KERNEL_ARTIFACT_ID = "neo4j-kernel";
    private static final Version KERNEL_VERSION;
    private final String title;
    private final String vendor;
    private final String version;

    @Override
    public String toString() {
        if (this.title == null) {
            return "Neo4j Kernel, unpackaged version " + this.getVersion();
        }
        return this.title + " " + this.getVersion();
    }

    public String getVersion() {
        if (this.version == null || this.version.equals("")) {
            String revision = this.getRevision();
            if (revision == null || revision.equals("")) {
                return "unknown";
            }
            return "revision: " + this.getRevision();
        }
        if (this.version.contains("SNAPSHOT")) {
            String revision = this.getRevision();
            if (revision == null || revision.equals("")) {
                return this.version;
            }
            return this.version + " (revision: " + this.getRevision() + ")";
        }
        return this.version;
    }

    public String getReleaseVersion() {
        return this.version;
    }

    public String getRevision() {
        return "";
    }

    protected Version(String atrifactId, String version) {
        super(atrifactId, new String[0]);
        Package pkg = this.getClass().getPackage();
        this.title = Version.defaultValue(pkg.getImplementationTitle(), atrifactId);
        this.vendor = Version.defaultValue(pkg.getImplementationVendor(), "Neo Technology");
        this.version = Version.defaultValue(pkg.getImplementationVersion(), version);
    }

    private static String defaultValue(String preferred, String fallback) {
        return preferred == null || preferred.equals("") ? fallback : preferred;
    }

    static Version getKernel() {
        return KERNEL_VERSION;
    }

    public static String getKernelRevision() {
        return KERNEL_VERSION.getRevision();
    }

    static {
        Version kernelVersion = null;
        try {
            kernelVersion = Service.load(Version.class, KERNEL_ARTIFACT_ID);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (kernelVersion == null) {
            kernelVersion = new Version(KERNEL_ARTIFACT_ID, "");
        }
        KERNEL_VERSION = kernelVersion;
    }
}

