/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.Title;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;

public class SettingsResourceBundle
extends ResourceBundle {
    private final Class settingsClass;

    public SettingsResourceBundle(Class settingsClass) {
        this.settingsClass = settingsClass;
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key.equals("description")) {
            Description description = this.settingsClass.getAnnotation(Description.class);
            return description.value();
        }
        String name = key.substring(0, key.lastIndexOf("."));
        if (key.endsWith(".description")) {
            Field settingField = this.getField(name);
            return settingField.getAnnotation(Description.class).value();
        }
        if (key.endsWith(".title")) {
            Field settingField = this.getField(name);
            Title annotation = settingField.getAnnotation(Title.class);
            if (annotation != null) {
                return annotation.value();
            }
            name = name.replace('_', ' ');
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            return name;
        }
        if (key.endsWith(".default")) {
            Field settingField = this.getField(name);
            try {
                return ((Setting)settingField.get(null)).apply(Functions.nullFunction()).toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalResourceException("Could not find resource for property " + key);
    }

    private Field getField(String name) {
        for (Field field : this.settingsClass.getFields()) {
            if (!GraphDatabaseSetting.class.isAssignableFrom(field.getType())) continue;
            try {
                GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                if (!setting.name().equals(name)) continue;
                return field;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalResourceException("Could not find resource for property with prefix " + name);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        Description description = this.settingsClass.getAnnotation(Description.class);
        if (description != null) {
            keys.add("description");
        }
        for (Field field : this.settingsClass.getFields()) {
            try {
                GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                if (field.getAnnotation(Description.class) == null) continue;
                keys.add(setting.name() + ".description");
                if (setting.apply(Functions.nullFunction()) == null) continue;
                keys.add(setting.name() + ".default");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return keys;
    }

    private Field findOptionField(String option, Class<? extends GraphDatabaseSetting> optionsClass) throws NoSuchFieldException {
        for (Field optionField : optionsClass.getFields()) {
            try {
                if (!option.equals(optionField.get(null))) continue;
                return optionField;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        throw new NoSuchFieldException("No field found for option " + option);
    }
}

