/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.RestartOnChange;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;
import org.slf4j.Logger;

public class LogbackService
extends LifecycleAdapter
implements Logging {
    private Config config;
    private final LoggerContext loggerContext;
    private LifeSupport loggingLife = new LifeSupport();
    protected RestartOnChange restartOnChange;

    public LogbackService(Config config, LoggerContext loggerContext) {
        this.config = config;
        this.loggerContext = loggerContext;
    }

    @Override
    public void init() throws Throwable {
        final String storeDir = this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir);
        if (storeDir != null) {
            File file = new File(storeDir).getAbsoluteFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            this.loggingLife.add(new LifecycleAdapter(){

                @Override
                public void start() throws Throwable {
                    JoranConfigurator configurator = new JoranConfigurator();
                    configurator.setContext((Context)LogbackService.this.loggerContext);
                    LogbackService.this.loggerContext.putProperty("neo_store", storeDir);
                    LogbackService.this.loggerContext.putProperty("remote_logging_enabled", LogbackService.this.config.get(GraphDatabaseSettings.remote_logging_enabled).toString());
                    LogbackService.this.loggerContext.putProperty("remote_logging_host", LogbackService.this.config.get(GraphDatabaseSettings.remote_logging_host));
                    LogbackService.this.loggerContext.putProperty("remote_logging_port", LogbackService.this.config.get(GraphDatabaseSettings.remote_logging_port).toString());
                    try {
                        configurator.doConfigure(this.getClass().getResource("/neo4j-logback.xml"));
                    }
                    catch (JoranException e) {
                        throw new IllegalStateException("Failed to configure logging", e);
                    }
                }

                @Override
                public void stop() throws Throwable {
                    LogbackService.this.loggerContext.getLogger("neo4j").detachAndStopAllAppenders();
                }
            });
            this.loggingLife.start();
            this.restartOnChange = new RestartOnChange("remote_logging_", (Lifecycle)this.loggingLife);
            this.config.addConfigurationChangeListener(this.restartOnChange);
        }
    }

    @Override
    public void shutdown() throws Throwable {
        this.loggingLife.shutdown();
        if (this.restartOnChange != null) {
            this.config.removeConfigurationChangeListener(this.restartOnChange);
        }
    }

    @Override
    public StringLogger getLogger(String name) {
        return new Slf4jStringLogger((Logger)this.loggerContext.getLogger(name));
    }

    public static class Slf4jStringLogger
    extends StringLogger {
        Logger logger;

        Slf4jStringLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        protected void logLine(String line) {
            this.logger.info(line);
        }

        @Override
        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger> source, final boolean flush) {
            this.logMessage(msg, flush);
            source.visit(new StringLogger.LineLogger(){

                @Override
                public void logLine(String line) {
                    Slf4jStringLogger.this.logMessage(line, flush);
                }
            });
        }

        @Override
        public void logMessage(String msg, boolean flush) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(msg);
            } else {
                this.logger.info(msg);
            }
        }

        @Override
        public void logMessage(String msg, Throwable cause, boolean flush) {
            this.logger.error(msg, cause);
        }

        @Override
        public void debug(String msg) {
            this.logger.debug(msg);
        }

        @Override
        public void debug(String msg, Throwable cause) {
            this.logger.debug(msg, cause);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void info(String msg) {
            this.logger.info(msg);
        }

        @Override
        public void info(String msg, Throwable cause) {
            this.logger.info(msg, cause);
        }

        @Override
        public void warn(String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(String msg, Throwable throwable) {
            this.logger.warn(msg, throwable);
        }

        @Override
        public void error(String msg) {
            this.logger.error(msg);
        }

        @Override
        public void error(String msg, Throwable throwable) {
            this.logger.error(msg, throwable);
        }

        @Override
        public void addRotationListener(Runnable listener) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

