/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.ShortString;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecordFetcher;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyRecord;

public enum LegacyPropertyType {
    ILLEGAL(0){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            throw new InvalidRecordException("Invalid type: 0 for record " + record);
        }
    }
    ,
    INT(1){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return (int)record.getPropBlock();
        }
    }
    ,
    STRING(2){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return store.getStringFor(record);
        }
    }
    ,
    BOOL(3){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return this.getValue(record.getPropBlock());
        }

        private Boolean getValue(long propBlock) {
            return propBlock == 1L ? Boolean.TRUE : Boolean.FALSE;
        }
    }
    ,
    DOUBLE(4){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return Double.longBitsToDouble(record.getPropBlock());
        }

        private double getValue(long propBlock) {
            return Double.longBitsToDouble(propBlock);
        }
    }
    ,
    FLOAT(5){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return Float.valueOf(this.getValue(record.getPropBlock()));
        }

        private float getValue(long propBlock) {
            return Float.intBitsToFloat((int)propBlock);
        }
    }
    ,
    LONG(6){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return record.getPropBlock();
        }
    }
    ,
    BYTE(7){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return (byte)record.getPropBlock();
        }
    }
    ,
    CHAR(8){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return Character.valueOf((char)record.getPropBlock());
        }
    }
    ,
    ARRAY(9){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return store.getArrayFor(record);
        }
    }
    ,
    SHORT(10){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return (short)record.getPropBlock();
        }
    }
    ,
    SHORT_STRING(11){

        @Override
        public Object getValue(LegacyPropertyRecord record, LegacyDynamicRecordFetcher store) {
            return ShortString.decode(record.getPropBlock());
        }
    };

    private int type;

    private LegacyPropertyType(int type) {
        this.type = type;
    }

    public int intValue() {
        return this.type;
    }

    public abstract Object getValue(LegacyPropertyRecord var1, LegacyDynamicRecordFetcher var2);

    public static LegacyPropertyType getPropertyType(int type, boolean nullOnIllegal) {
        switch (type) {
            case 0: {
                if (!nullOnIllegal) break;
                return null;
            }
            case 1: {
                return INT;
            }
            case 2: {
                return STRING;
            }
            case 3: {
                return BOOL;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return FLOAT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return BYTE;
            }
            case 8: {
                return CHAR;
            }
            case 9: {
                return ARRAY;
            }
            case 10: {
                return SHORT;
            }
            case 11: {
                return SHORT_STRING;
            }
        }
        throw new InvalidRecordException("Unknown property type:" + type);
    }
}

