/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.storemigration.PropertyWriter;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecordFetcher;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNeoStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyIndexStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipTypeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;

public class StoreMigrator {
    private MigrationProgressMonitor progressMonitor;

    public StoreMigrator(MigrationProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void migrate(LegacyStore legacyStore, NeoStore neoStore) throws IOException {
        this.progressMonitor.started();
        new Migration(legacyStore, neoStore).migrate();
        this.progressMonitor.finished();
    }

    protected class Migration {
        private LegacyStore legacyStore;
        private NeoStore neoStore;
        private long totalEntities;
        private int percentComplete = 0;

        public Migration(LegacyStore legacyStore, NeoStore neoStore) {
            this.legacyStore = legacyStore;
            this.neoStore = neoStore;
            this.totalEntities = legacyStore.getNodeStoreReader().getMaxId() + legacyStore.getRelationshipStoreReader().getMaxId();
        }

        private void migrate() throws IOException {
            this.migrateNeoStore(this.neoStore);
            this.migrateNodes(this.neoStore.getNodeStore(), new PropertyWriter(this.neoStore.getPropertyStore()));
            this.migrateRelationships(this.neoStore.getRelationshipStore(), new PropertyWriter(this.neoStore.getPropertyStore()));
            this.migratePropertyIndexes(this.neoStore.getPropertyStore().getIndexStore());
            this.legacyStore.getPropertyStoreReader().close();
            this.migrateRelationshipTypes(this.neoStore.getRelationshipTypeStore());
            this.legacyStore.close();
        }

        private void migrateNeoStore(NeoStore neoStore) {
            LegacyNeoStoreReader neoStoreReader = this.legacyStore.getNeoStoreReader();
            neoStore.setCreationTime(neoStoreReader.getCreationTime());
            neoStore.setRandomNumber(neoStoreReader.getRandomNumber());
            neoStore.setVersion(neoStoreReader.getVersion());
            this.updateLastCommittedTxInSimulatedRecoveredStatus(neoStore, neoStoreReader.getLastCommittedTx());
        }

        private void updateLastCommittedTxInSimulatedRecoveredStatus(NeoStore neoStore, long lastCommittedTx) {
            neoStore.setRecoveredStatus(true);
            neoStore.setLastCommittedTx(lastCommittedTx);
            neoStore.setRecoveredStatus(false);
        }

        private void migrateNodes(NodeStore nodeStore, PropertyWriter propertyWriter) throws IOException {
            Iterable<NodeRecord> records = this.legacyStore.getNodeStoreReader().readNodeStore();
            for (NodeRecord nodeRecord : records) {
                this.reportProgress(nodeRecord.getId());
                nodeStore.setHighId(nodeRecord.getId() + 1L);
                if (nodeRecord.inUse()) {
                    long startOfPropertyChain = nodeRecord.getNextProp();
                    if (startOfPropertyChain != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                        long propertyRecordId = this.migrateProperties(startOfPropertyChain, propertyWriter);
                        nodeRecord.setNextProp(propertyRecordId);
                    }
                    nodeStore.updateRecord(nodeRecord);
                    continue;
                }
                nodeStore.freeId(nodeRecord.getId());
            }
            this.legacyStore.getNodeStoreReader().close();
        }

        private void migrateRelationships(RelationshipStore relationshipStore, PropertyWriter propertyWriter) throws IOException {
            long nodeMaxId = this.legacyStore.getNodeStoreReader().getMaxId();
            Iterable<RelationshipRecord> records = this.legacyStore.getRelationshipStoreReader().readRelationshipStore();
            for (RelationshipRecord relationshipRecord : records) {
                this.reportProgress(nodeMaxId + relationshipRecord.getId());
                relationshipStore.setHighId(relationshipRecord.getId() + 1L);
                if (relationshipRecord.inUse()) {
                    long startOfPropertyChain = relationshipRecord.getNextProp();
                    if (startOfPropertyChain != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                        long propertyRecordId = this.migrateProperties(startOfPropertyChain, propertyWriter);
                        relationshipRecord.setNextProp(propertyRecordId);
                    }
                    relationshipStore.updateRecord(relationshipRecord);
                    continue;
                }
                relationshipStore.freeId(relationshipRecord.getId());
            }
            this.legacyStore.getRelationshipStoreReader().close();
        }

        private void reportProgress(long id) {
            int newPercent = (int)(id * 100L / this.totalEntities);
            if (newPercent > this.percentComplete) {
                this.percentComplete = newPercent;
                StoreMigrator.this.progressMonitor.percentComplete(this.percentComplete);
            }
        }

        private long migrateProperties(long startOfPropertyChain, PropertyWriter propertyWriter) throws IOException {
            LegacyPropertyRecord propertyRecord = this.legacyStore.getPropertyStoreReader().readPropertyRecord(startOfPropertyChain);
            ArrayList<Pair<Integer, Object>> properties = new ArrayList<Pair<Integer, Object>>();
            while (propertyRecord.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                properties.add(this.extractValue(propertyRecord));
                propertyRecord = this.legacyStore.getPropertyStoreReader().readPropertyRecord(propertyRecord.getNextProp());
            }
            properties.add(this.extractValue(propertyRecord));
            return propertyWriter.writeProperties(properties);
        }

        private Pair<Integer, Object> extractValue(LegacyPropertyRecord propertyRecord) {
            int keyIndexId = propertyRecord.getKeyIndexId();
            Object value = propertyRecord.getType().getValue(propertyRecord, this.legacyStore.getDynamicRecordFetcher());
            return Pair.of(keyIndexId, value);
        }

        public void migrateRelationshipTypes(RelationshipTypeStore relationshipTypeStore) throws IOException {
            LegacyRelationshipTypeStoreReader relationshipTypeStoreReader = this.legacyStore.getRelationshipTypeStoreReader();
            LegacyDynamicStoreReader relationshipTypeNameStoreReader = this.legacyStore.getRelationshipTypeNameStoreReader();
            for (RelationshipTypeRecord relationshipTypeRecord : relationshipTypeStoreReader.readRelationshipTypes()) {
                List<LegacyDynamicRecord> dynamicRecords = relationshipTypeNameStoreReader.getPropertyChain(relationshipTypeRecord.getNameId());
                String name = LegacyDynamicRecordFetcher.joinRecordsIntoString(relationshipTypeRecord.getNameId(), dynamicRecords);
                this.createRelationshipType(relationshipTypeStore, name, relationshipTypeRecord.getId());
            }
            relationshipTypeNameStoreReader.close();
        }

        public void createRelationshipType(RelationshipTypeStore relationshipTypeStore, String name, int id) {
            long nextIdFromStore = relationshipTypeStore.nextId();
            while (nextIdFromStore < (long)id) {
                nextIdFromStore = relationshipTypeStore.nextId();
            }
            RelationshipTypeRecord record = new RelationshipTypeRecord(id);
            record.setInUse(true);
            record.setCreated();
            int keyBlockId = relationshipTypeStore.nextNameId();
            record.setNameId(keyBlockId);
            Collection<DynamicRecord> keyRecords = relationshipTypeStore.allocateNameRecords(keyBlockId, PropertyStore.encodeString(name));
            for (DynamicRecord keyRecord : keyRecords) {
                record.addNameRecord(keyRecord);
            }
            relationshipTypeStore.updateRecord(record);
        }

        public void migratePropertyIndexes(PropertyIndexStore propIndexStore) throws IOException {
            LegacyPropertyIndexStoreReader indexStoreReader = this.legacyStore.getPropertyIndexStoreReader();
            LegacyDynamicStoreReader propertyIndexKeyStoreReader = this.legacyStore.getPropertyIndexKeyStoreReader();
            for (PropertyIndexRecord propertyIndexRecord : indexStoreReader.readPropertyIndexStore()) {
                List<LegacyDynamicRecord> dynamicRecords = propertyIndexKeyStoreReader.getPropertyChain(propertyIndexRecord.getNameId());
                String key = LegacyDynamicRecordFetcher.joinRecordsIntoString(propertyIndexRecord.getNameId(), dynamicRecords);
                this.createPropertyIndex(propIndexStore, key, propertyIndexRecord.getId());
            }
            propertyIndexKeyStoreReader.close();
        }

        public void createPropertyIndex(PropertyIndexStore propIndexStore, String key, int id) {
            long nextIdFromStore = propIndexStore.nextId();
            while (nextIdFromStore < (long)id) {
                nextIdFromStore = propIndexStore.nextId();
            }
            PropertyIndexRecord record = new PropertyIndexRecord(id);
            record.setInUse(true);
            record.setCreated();
            int keyBlockId = propIndexStore.nextNameId();
            record.setNameId(keyBlockId);
            Collection<DynamicRecord> keyRecords = propIndexStore.allocateNameRecords(keyBlockId, PropertyStore.encodeString(key));
            for (DynamicRecord keyRecord : keyRecords) {
                record.addNameRecord(keyRecord);
            }
            propIndexStore.updateRecord(record);
        }
    }
}

