/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.impl.util.FileUtils;

public class StoreFiles {
    public static final String[] fileNames = new String[]{"neostore", "neostore.nodestore.db", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.index", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.strings", "neostore.relationshipstore.db", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.names"};

    public static void move(File fromDirectory, File toDirectory) throws IOException {
        for (String fileName : fileNames) {
            StoreFiles.moveFile(fileName, fromDirectory, toDirectory);
            StoreFiles.moveFile(fileName + ".id", fromDirectory, toDirectory);
        }
    }

    static void moveFile(String fileName, File fromDirectory, File toDirectory) throws IOException {
        if (FileUtils.moveFileToDirectory(new File(fromDirectory, fileName), toDirectory) == null) {
            throw new IOException("Move of file " + fileName + " from " + fromDirectory.getAbsolutePath() + " to directory " + toDirectory.getAbsolutePath() + " failed");
        }
    }
}

