/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreFactory {
    protected static final Logger logger = Logger.getLogger(StoreFactory.class.getName());
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final WindowPoolFactory windowPoolFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final StringLogger stringLogger;
    private final TxHook txHook;

    public StoreFactory(Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, TxHook txHook) {
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.windowPoolFactory = windowPoolFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.stringLogger = stringLogger;
        this.txHook = txHook;
    }

    public boolean ensureStoreExists() throws IOException {
        boolean readOnly = this.config.get(GraphDatabaseSettings.read_only);
        String store = this.config.get(GraphDatabaseSettings.neo_store);
        boolean created = false;
        if (!readOnly && !this.fileSystemAbstraction.fileExists(store)) {
            this.stringLogger.logMessage("Creating new db @ " + store, true);
            this.fileSystemAbstraction.autoCreatePath(store);
            this.createNeoStore(store).close();
            created = true;
        }
        return created;
    }

    public NeoStore newNeoStore(String fileName) {
        try {
            return this.attemptNewNeoStore(fileName);
        }
        catch (NotCurrentStoreVersionException e) {
            this.tryToUpgradeStores(fileName);
            return this.attemptNewNeoStore(fileName);
        }
    }

    NeoStore attemptNewNeoStore(String fileName) {
        return new NeoStore(fileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, this.txHook, this.newRelationshipTypeStore(fileName + ".relationshiptypestore.db"), this.newPropertyStore(fileName + ".propertystore.db"), this.newRelationshipStore(fileName + ".relationshipstore.db"), this.newNodeStore(fileName + ".nodestore.db"));
    }

    private void tryToUpgradeStores(String fileName) {
        new StoreUpgrader(this.config, this.stringLogger, new ConfigMapUpgradeConfiguration(this.config), new UpgradableDatabase(), new StoreMigrator(new VisibleMigrationProgressMonitor(System.out)), new DatabaseFiles(), this.idGeneratorFactory, this.fileSystemAbstraction).attemptUpgrade(fileName);
    }

    private DynamicStringStore newDynamicStringStore(String s, IdType nameIdType) {
        return new DynamicStringStore(s, this.config, nameIdType, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    private RelationshipTypeStore newRelationshipTypeStore(String s) {
        DynamicStringStore nameStore = this.newDynamicStringStore(s + ".names", IdType.RELATIONSHIP_TYPE_BLOCK);
        return new RelationshipTypeStore(s, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, nameStore);
    }

    private PropertyStore newPropertyStore(String s) {
        DynamicStringStore stringPropertyStore = this.newDynamicStringStore(s + ".strings", IdType.STRING_BLOCK);
        PropertyIndexStore propertyIndexStore = this.newPropertyIndexStore(s + ".index");
        DynamicArrayStore arrayPropertyStore = this.newDynamicArrayStore(s + ".arrays");
        return new PropertyStore(s, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, stringPropertyStore, propertyIndexStore, arrayPropertyStore);
    }

    private PropertyIndexStore newPropertyIndexStore(String s) {
        DynamicStringStore nameStore = this.newDynamicStringStore(s + ".keys", IdType.PROPERTY_INDEX_BLOCK);
        return new PropertyIndexStore(s, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, nameStore);
    }

    private RelationshipStore newRelationshipStore(String s) {
        return new RelationshipStore(s, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    private DynamicArrayStore newDynamicArrayStore(String s) {
        return new DynamicArrayStore(s, this.config, IdType.ARRAY_BLOCK, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    private NodeStore newNodeStore(String s) {
        return new NodeStore(s, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    public NeoStore createNeoStore(String fileName) {
        return this.createNeoStore(fileName, new StoreId());
    }

    public NeoStore createNeoStore(String fileName, StoreId storeId) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("NeoStore"));
        this.createNodeStore(fileName + ".nodestore.db");
        this.createRelationshipStore(fileName + ".relationshipstore.db");
        this.createPropertyStore(fileName + ".propertystore.db");
        this.createRelationshipTypeStore(fileName + ".relationshiptypestore.db");
        NeoStore neoStore = this.newNeoStore(fileName);
        for (int i = 0; i < 6; ++i) {
            neoStore.nextId();
        }
        neoStore.setCreationTime(storeId.getCreationTime());
        neoStore.setRandomNumber(storeId.getRandomId());
        neoStore.setVersion(0L);
        neoStore.setLastCommittedTx(1L);
        neoStore.setStoreVersion(storeId.getStoreVersion());
        neoStore.setGraphNextProp(-1L);
        return neoStore;
    }

    private void createNodeStore(String fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("NodeStore"));
        NodeStore store = this.newNodeStore(fileName);
        NodeRecord nodeRecord = new NodeRecord(store.nextId(), Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        nodeRecord.setInUse(true);
        store.updateRecord(nodeRecord);
        store.close();
    }

    private void createRelationshipStore(String fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    private void createPropertyStore(String fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("PropertyStore"));
        int stringStoreBlockSize = this.config.get(Configuration.string_block_size);
        int arrayStoreBlockSize = this.config.get(Configuration.array_block_size);
        this.createDynamicStringStore(fileName + ".strings", stringStoreBlockSize, IdType.STRING_BLOCK);
        this.createPropertyIndexStore(fileName + ".index");
        this.createDynamicArrayStore(fileName + ".arrays", arrayStoreBlockSize);
    }

    private void createRelationshipTypeStore(String fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
        this.createDynamicStringStore(fileName + ".names", 30, IdType.RELATIONSHIP_TYPE_BLOCK);
        RelationshipTypeStore store = this.newRelationshipTypeStore(fileName);
        store.close();
    }

    private void createDynamicStringStore(String fileName, int blockSize, IdType idType) {
        this.createEmptyDynamicStore(fileName, blockSize, "StringPropertyStore v0.A.0", idType);
    }

    private void createPropertyIndexStore(String fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("PropertyIndexStore"));
        this.createDynamicStringStore(fileName + ".keys", 30, IdType.PROPERTY_INDEX_BLOCK);
    }

    public void createDynamicArrayStore(String fileName, int blockSize) {
        this.createEmptyDynamicStore(fileName, blockSize, "ArrayPropertyStore v0.A.0", IdType.ARRAY_BLOCK);
    }

    public void createEmptyDynamicStore(String fileName, int baseBlockSize, String typeAndVersionDescriptor, IdType idType) {
        int blockSize = baseBlockSize;
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "]");
        }
        if (blockSize > 65535) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "], limit is 65535");
        }
        blockSize += 8;
        try {
            FileChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = blockSize + UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.putInt(blockSize);
            buffer.position(endHeaderSize - typeAndVersionDescriptor.length());
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, fileName + ".id", 0L);
        IdGenerator idGenerator = this.idGeneratorFactory.open(this.fileSystemAbstraction, fileName + ".id", 1, idType);
        idGenerator.nextId();
        idGenerator.close();
    }

    public void createEmptyStore(String fileName, String typeAndVersionDescriptor) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        try {
            FileChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, fileName + ".id", 0L);
    }

    public String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return typeDescriptor + " " + "v0.A.0";
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting.IntegerSetting string_block_size = GraphDatabaseSettings.string_block_size;
        public static final GraphDatabaseSetting.IntegerSetting array_block_size = GraphDatabaseSettings.array_block_size;
    }
}

