/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class PropertyIndexStore
extends AbstractNameStore<PropertyIndexRecord> {
    public static final String TYPE_DESCRIPTOR = "PropertyIndexStore";
    private static final int RECORD_SIZE = 9;

    public PropertyIndexStore(String fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore) {
        super(fileName, config, IdType.PROPERTY_INDEX, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger, nameStore);
    }

    @Override
    public void accept(RecordStore.Processor processor, PropertyIndexRecord record) {
        processor.processPropertyIndex(this, record);
    }

    @Override
    protected PropertyIndexRecord newRecord(int id) {
        return new PropertyIndexRecord(id);
    }

    @Override
    protected void readRecord(PropertyIndexRecord record, Buffer buffer) {
        record.setPropertyCount(buffer.getInt());
        record.setNameId(buffer.getInt());
    }

    @Override
    protected void writeRecord(PropertyIndexRecord record, Buffer buffer) {
        buffer.putInt(record.getPropertyCount());
        buffer.putInt(record.getNameId());
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public static abstract class Configuration
    extends AbstractNameStore.Configuration {
    }
}

