/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class DefaultWindowPoolFactory
implements WindowPoolFactory {
    @Deprecated
    private static Logger logger = Logger.getLogger(DefaultWindowPoolFactory.class.getName());

    @Override
    public WindowPool create(String storageFileName, int recordSize, FileChannel fileChannel, Config configuration, StringLogger log) {
        return new PersistenceWindowPool(storageFileName, recordSize, fileChannel, this.calculateMappedMemory(configuration.getParams(), storageFileName), configuration.get(CommonAbstractStore.Configuration.use_memory_mapped_buffers), this.isReadOnly(configuration) && !this.isBackupSlave(configuration), log);
    }

    private boolean isBackupSlave(Config configuration) {
        return configuration.get(CommonAbstractStore.Configuration.backup_slave);
    }

    private boolean isReadOnly(Config configuration) {
        return configuration.get(CommonAbstractStore.Configuration.read_only);
    }

    private long calculateMappedMemory(Map<?, ?> config, String storageFileName) {
        String convertSlash = storageFileName.replace('\\', '/');
        String realName = convertSlash.substring(convertSlash.lastIndexOf(47) + 1);
        String mem = (String)config.get(realName + ".mapped_memory");
        if (mem != null) {
            long multiplier = 1L;
            if ((mem = mem.trim().toLowerCase()).endsWith("m")) {
                multiplier = 0x100000L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("k")) {
                multiplier = 1024L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("g")) {
                multiplier = 0x40000000L;
                mem = mem.substring(0, mem.length() - 1);
            }
            try {
                return (long)Integer.parseInt(mem) * multiplier;
            }
            catch (NumberFormatException e) {
                logger.info("Unable to parse mapped memory[" + mem + "] string for " + storageFileName);
            }
        }
        return 0L;
    }
}

