/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Specification;
import org.neo4j.helpers.Specifications;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class RestartOnChange
implements ConfigurationChangeListener {
    private final Specification<String> restartSpecification;
    private final Lifecycle life;

    public RestartOnChange(Class<?> settingsClass, Lifecycle life) {
        this(Specifications.or(Iterables.map(new Function<Field, Specification<String>>(){

            @Override
            public Specification<String> map(Field method) {
                try {
                    GraphDatabaseSetting setting = (GraphDatabaseSetting)method.get(null);
                    return Specifications.in(setting.name());
                }
                catch (IllegalAccessException e) {
                    return Specifications.not(Specifications.TRUE());
                }
            }
        }, Arrays.asList(settingsClass.getFields()))), life);
    }

    public RestartOnChange(final String configurationNamePrefix, Lifecycle life) {
        this(new Specification<String>(){

            @Override
            public boolean satisfiedBy(String item) {
                return item.startsWith(configurationNamePrefix);
            }
        }, life);
    }

    public RestartOnChange(Specification<String> restartSpecification, Lifecycle life) {
        this.restartSpecification = restartSpecification;
        this.life = life;
    }

    @Override
    public void notifyConfigurationChanges(Iterable<ConfigurationChange> change) {
        boolean restart = false;
        for (ConfigurationChange configurationChange : change) {
            restart |= this.restartSpecification.satisfiedBy(configurationChange.getName());
        }
        if (restart) {
            try {
                this.life.stop();
                this.life.start();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

