/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.traversal.TraverserImpl;
import org.neo4j.kernel.impl.traversal.TraverserIterator;

class SortingTraverserIterator
extends PrefetchingIterator<Path>
implements TraversalContext {
    private final TraverserImpl traverserImpl;
    private final TraverserIterator source;
    private Iterator<Path> sortedResultIterator;

    SortingTraverserIterator(TraverserImpl traverserImpl, TraverserIterator source) {
        this.traverserImpl = traverserImpl;
        this.source = source;
    }

    @Override
    public int getNumberOfPathsReturned() {
        return this.source.getNumberOfPathsReturned();
    }

    @Override
    public int getNumberOfRelationshipsTraversed() {
        return this.source.getNumberOfRelationshipsTraversed();
    }

    @Override
    public void relationshipTraversed() {
        this.source.relationshipTraversed();
    }

    @Override
    public void unnecessaryRelationshipTraversed() {
        this.source.unnecessaryRelationshipTraversed();
    }

    @Override
    public boolean isUniqueFirst(TraversalBranch branch) {
        return this.source.isUniqueFirst(branch);
    }

    @Override
    public boolean isUnique(TraversalBranch branch) {
        return this.source.isUnique(branch);
    }

    @Override
    public Evaluation evaluate(TraversalBranch branch) {
        return this.source.evaluate(branch);
    }

    @Override
    protected Path fetchNextOrNull() {
        if (this.sortedResultIterator == null) {
            this.sortedResultIterator = this.fetchAndSortResult();
        }
        return this.sortedResultIterator.hasNext() ? this.sortedResultIterator.next() : null;
    }

    private Iterator<Path> fetchAndSortResult() {
        ArrayList result = new ArrayList();
        while (this.source.hasNext()) {
            result.add(this.source.next());
        }
        Collections.sort(result, this.traverserImpl.description.sorting);
        return result.iterator();
    }
}

