/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TransactionImpl;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxLog;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.XaResource;
import org.neo4j.kernel.impl.util.ExceptionCauseSetter;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class TxManager
extends AbstractTransactionManager
implements Lifecycle {
    private static Logger log = Logger.getLogger(TxManager.class.getName());
    private Map<Thread, TransactionImpl> txThreadMap = new ConcurrentHashMap<Thread, TransactionImpl>();
    private final String txLogDir;
    private static String separator = File.separator;
    private String logSwitcherFileName = "active_tx_log";
    private String txLog1FileName = "tm_tx_log.1";
    private String txLog2FileName = "tm_tx_log.2";
    private final int maxTxLogRecordCount = 1000;
    private int eventIdentifierCounter = 0;
    private TxLog txLog = null;
    private boolean tmOk = false;
    private boolean blocked = false;
    private final KernelPanicEventGenerator kpe;
    private final AtomicInteger startedTxCount = new AtomicInteger(0);
    private final AtomicInteger comittedTxCount = new AtomicInteger(0);
    private final AtomicInteger rolledBackTxCount = new AtomicInteger(0);
    private int peakConcurrentTransactions = 0;
    private final StringLogger msgLog;
    final TxHook finishHook;
    private XaDataSourceManager xaDataSourceManager;
    private final FileSystemAbstraction fileSystem;

    public TxManager(String txLogDir, XaDataSourceManager xaDataSourceManager, KernelPanicEventGenerator kpe, TxHook finishHook, StringLogger msgLog, FileSystemAbstraction fileSystem) {
        this.txLogDir = txLogDir;
        this.xaDataSourceManager = xaDataSourceManager;
        this.fileSystem = fileSystem;
        this.msgLog = msgLog;
        this.kpe = kpe;
        this.finishHook = finishHook;
    }

    synchronized int getNextEventIdentifier() {
        return this.eventIdentifierCounter++;
    }

    private <E extends Exception> E logAndReturn(String msg, E exception) {
        try {
            this.msgLog.logMessage(msg, exception, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exception;
    }

    @Override
    public void init() {
        this.txThreadMap = new ConcurrentHashMap<Thread, TransactionImpl>();
        this.logSwitcherFileName = this.txLogDir + separator + "active_tx_log";
        this.txLog1FileName = "tm_tx_log.1";
        this.txLog2FileName = "tm_tx_log.2";
        try {
            if (this.fileSystem.fileExists(this.logSwitcherFileName)) {
                FileChannel fc = this.fileSystem.open(this.logSwitcherFileName, "rw");
                byte[] fileName = new byte[256];
                ByteBuffer buf = ByteBuffer.wrap(fileName);
                fc.read(buf);
                fc.close();
                String currentTxLog = this.txLogDir + separator + UTF8.decode(fileName).trim();
                if (!this.fileSystem.fileExists(currentTxLog)) {
                    throw this.logAndReturn("TM startup failure", new TransactionFailureException("Unable to start TM, active tx log file[" + currentTxLog + "] not found."));
                }
                this.txLog = new TxLog(currentTxLog, this.fileSystem, this.msgLog);
                this.msgLog.logMessage("TM opening log: " + currentTxLog, true);
            } else {
                if (this.fileSystem.fileExists(this.txLogDir + separator + this.txLog1FileName) || this.fileSystem.fileExists(this.txLogDir + separator + this.txLog2FileName)) {
                    throw this.logAndReturn("TM startup failure", new TransactionFailureException("Unable to start TM, no active tx log file found but found either " + this.txLog1FileName + " or " + this.txLog2FileName + " file, please set one of them as active or " + "remove them."));
                }
                ByteBuffer buf = ByteBuffer.wrap(this.txLog1FileName.getBytes("UTF-8"));
                FileChannel fc = this.fileSystem.open(this.logSwitcherFileName, "rw");
                fc.write(buf);
                this.txLog = new TxLog(this.txLogDir + separator + this.txLog1FileName, this.fileSystem, this.msgLog);
                this.msgLog.logMessage("TM new log: " + this.txLog1FileName, true);
                fc.force(true);
                fc.close();
            }
            this.tmOk = true;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Unable to start TM", e);
            throw this.logAndReturn("TM startup failure", new TransactionFailureException("Unable to start TM", e));
        }
    }

    @Override
    public void start() throws Throwable {
        Iterator<List<TxLog.Record>> danglingRecordList = this.txLog.getDanglingRecords();
        boolean danglingRecordFound = danglingRecordList.hasNext();
        if (danglingRecordFound) {
            log.info("Unresolved transactions found, recovery started ...");
            this.msgLog.logMessage("TM non resolved transactions found in " + this.txLog.getName(), true);
            this.xaDataSourceManager.recover(danglingRecordList);
            log.info("Recovery completed, all transactions have been resolved to a consistent state.");
            this.msgLog.logMessage("Recovery completed, all transactions have been resolved to a consistent state.");
        }
        this.getTxLog().truncate();
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() throws Throwable {
        if (this.txLog != null) {
            try {
                this.txLog.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Unable to close tx log[" + this.txLog.getName() + "]", e);
            }
        }
        this.msgLog.logMessage("TM shutting down", true);
    }

    synchronized TxLog getTxLog() throws IOException {
        if (this.txLog.getRecordCount() > 1000) {
            if (this.txLog.getName().endsWith(this.txLog1FileName)) {
                this.txLog.switchToLogFile(this.txLogDir + separator + this.txLog2FileName);
                this.changeActiveLog(this.txLog2FileName);
            } else if (this.txLog.getName().endsWith(this.txLog2FileName)) {
                this.txLog.switchToLogFile(this.txLogDir + separator + this.txLog1FileName);
                this.changeActiveLog(this.txLog1FileName);
            } else {
                this.setTmNotOk(new Exception("Unknown active tx log file[" + this.txLog.getName() + "], unable to switch."));
                log.severe("Unknown active tx log file[" + this.txLog.getName() + "], unable to switch.");
                IOException ex = new IOException("Unknown txLogFile[" + this.txLog.getName() + "] not equals to either [" + this.txLog1FileName + "] or [" + this.txLog2FileName + "]");
                throw this.logAndReturn("TM error accessing log file", ex);
            }
        }
        return this.txLog;
    }

    private void changeActiveLog(String newFileName) throws IOException {
        FileChannel fc = this.fileSystem.open(this.logSwitcherFileName, "rw");
        ByteBuffer buf = ByteBuffer.wrap(UTF8.encode(newFileName));
        fc.truncate(0L);
        fc.write(buf);
        fc.force(true);
        fc.close();
    }

    void setTmNotOk(Throwable cause) {
        this.tmOk = false;
        this.msgLog.logMessage("setting TM not OK", cause);
        this.kpe.generateEvent(ErrorState.TX_MANAGER_NOT_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attemptWaitForTxCompletionAndBlockFutureTransactions(long maxWaitTimeMillis) {
        this.msgLog.logMessage("TxManager is blocking new transactions and waiting for active to fail...");
        this.blocked = true;
        ArrayList<TransactionImpl> failedTransactions = new ArrayList<TransactionImpl>();
        Map<Thread, TransactionImpl> map = this.txThreadMap;
        synchronized (map) {
            for (TransactionImpl tx : this.txThreadMap.values()) {
                try {
                    int status = tx.getStatus();
                    if (status == 8 || status == 9) continue;
                    tx.setRollbackOnly();
                }
                catch (IllegalStateException e) {
                    failedTransactions.add(tx);
                }
                catch (SystemException e) {
                    failedTransactions.add(tx);
                }
            }
        }
        this.msgLog.logMessage("TxManager blocked transactions" + (failedTransactions.isEmpty() ? "" : ", but failed for: " + ((Object)failedTransactions).toString()));
        long endTime = System.currentTimeMillis() + maxWaitTimeMillis;
        while (this.txThreadMap.size() > 0 && System.currentTimeMillis() < endTime) {
            Thread.yield();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(ForceMode.forced);
    }

    @Override
    public void begin(ForceMode forceMode) throws NotSupportedException, SystemException {
        if (this.blocked) {
            throw new SystemException("TxManager is preventing new transactions from starting due a shutdown is imminent");
        }
        this.assertTmOk("tx begin");
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            throw this.logAndReturn("TM error tx begin", new NotSupportedException("Nested transactions not supported"));
        }
        tx = new TransactionImpl(this, forceMode);
        this.txThreadMap.put(thread, tx);
        int concurrentTxCount = this.txThreadMap.size();
        if (concurrentTxCount > this.peakConcurrentTransactions) {
            this.peakConcurrentTransactions = concurrentTxCount;
        }
        this.startedTxCount.incrementAndGet();
    }

    private void assertTmOk(String source) throws SystemException {
        if (!this.tmOk) {
            throw new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)");
        }
    }

    void writeStartRecord(byte[] globalId) throws SystemException {
        try {
            this.getTxLog().txStart(globalId);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error writing transaction log", e);
            this.setTmNotOk(e);
            throw (SystemException)((Object)this.logAndReturn("TM error write start record", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log,"), e))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        this.assertTmOk("tx commit");
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw this.logAndReturn("TM error tx commit", new IllegalStateException("Not in transaction"));
        }
        boolean hasAnyLocks = false;
        boolean successful = false;
        try {
            hasAnyLocks = this.finishHook.hasAnyLocks(tx);
            if (tx.getStatus() != 0 && tx.getStatus() != 1) {
                throw this.logAndReturn("TM error tx commit", new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus())));
            }
            tx.doBeforeCompletion();
            if (tx.getStatus() == 0) {
                this.comittedTxCount.incrementAndGet();
                this.commit(thread, tx);
            } else if (tx.getStatus() == 1) {
                this.rolledBackTxCount.incrementAndGet();
                this.rollbackCommit(thread, tx);
            } else {
                throw this.logAndReturn("TM error tx commit", new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus())));
            }
            successful = true;
        }
        finally {
            if (hasAnyLocks) {
                this.finishHook.finishTransaction(tx.getEventIdentifier(), successful);
            }
        }
    }

    private void commit(Thread thread, TransactionImpl tx) throws SystemException, HeuristicMixedException, HeuristicRollbackException {
        Throwable commitFailureCause = null;
        int xaErrorCode = -1;
        if (tx.getResourceCount() == 0) {
            tx.setStatus(3);
        } else {
            try {
                tx.doCommit();
            }
            catch (XAException e) {
                xaErrorCode = e.errorCode;
                log.log(Level.SEVERE, "Commit failed, status=" + this.getTxStatusAsString(tx.getStatus()) + ", errorCode=" + xaErrorCode, e);
                if (tx.getStatus() == 3) {
                    this.setTmNotOk(e);
                    throw this.logAndReturn("TM error tx commit", new TransactionFailureException("commit threw exception but status is committed?", e));
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Commit failed", t);
                commitFailureCause = t;
            }
        }
        if (tx.getStatus() != 3) {
            try {
                tx.doRollback();
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Unable to rollback transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
                this.setTmNotOk(e);
                String commitError = commitFailureCause != null ? "error in commit: " + commitFailureCause : "error code in commit: " + xaErrorCode;
                String rollbackErrorCode = "Uknown error code";
                if (e instanceof XAException) {
                    rollbackErrorCode = Integer.toString(((XAException)e).errorCode);
                }
                throw (HeuristicMixedException)this.logAndReturn("TM error tx commit", (Exception)Exceptions.withCause(new HeuristicMixedException("Unable to rollback ---> " + commitError + " ---> error code for rollback: " + rollbackErrorCode), e));
            }
            tx.doAfterCompletion();
            this.txThreadMap.remove(thread);
            try {
                if (tx.isGlobalStartRecordWritten()) {
                    this.getTxLog().txDone(tx.getGlobalId());
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error writing transaction log", e);
                this.setTmNotOk(e);
                throw (SystemException)((Object)this.logAndReturn("TM error tx commit", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
            }
            tx.setStatus(6);
            if (commitFailureCause == null) {
                throw this.logAndReturn("TM error tx commit", new HeuristicRollbackException("Failed to commit, transaction rolledback ---> error code was: " + xaErrorCode));
            }
            throw (HeuristicRollbackException)this.logAndReturn("TM error tx commit", (Exception)Exceptions.withCause(new HeuristicRollbackException("Failed to commit, transaction rolledback ---> " + commitFailureCause), commitFailureCause));
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        try {
            if (tx.isGlobalStartRecordWritten()) {
                this.getTxLog().txDone(tx.getGlobalId());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error writing transaction log", e);
            this.setTmNotOk(e);
            throw (SystemException)((Object)this.logAndReturn("TM error tx commit", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
        }
        tx.setStatus(6);
    }

    private void rollbackCommit(Thread thread, TransactionImpl tx) throws HeuristicMixedException, RollbackException, SystemException {
        try {
            tx.doRollback();
        }
        catch (XAException e) {
            log.log(Level.SEVERE, "Unable to rollback marked transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
            this.setTmNotOk(e);
            throw (HeuristicMixedException)this.logAndReturn("TM error tx rollback commit", (Exception)Exceptions.withCause(new HeuristicMixedException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e));
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        try {
            if (tx.isGlobalStartRecordWritten()) {
                this.getTxLog().txDone(tx.getGlobalId());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error writing transaction log", e);
            this.setTmNotOk(e);
            throw (SystemException)((Object)this.logAndReturn("TM error tx rollback commit", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
        }
        tx.setStatus(6);
        RollbackException rollbackException = new RollbackException("Failed to commit, transaction rolledback");
        ExceptionCauseSetter.setCause(rollbackException, tx.getRollbackCause());
        throw rollbackException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        block11: {
            this.assertTmOk("tx rollback");
            Thread thread = Thread.currentThread();
            TransactionImpl tx = this.txThreadMap.get(thread);
            if (tx == null) {
                throw new IllegalStateException("Not in transaction");
            }
            boolean hasAnyLocks = false;
            try {
                hasAnyLocks = this.finishHook.hasAnyLocks(tx);
                if (tx.getStatus() == 0 || tx.getStatus() == 1 || tx.getStatus() == 7) {
                    tx.setStatus(1);
                    tx.doBeforeCompletion();
                    try {
                        this.rolledBackTxCount.incrementAndGet();
                        tx.doRollback();
                    }
                    catch (XAException e) {
                        log.log(Level.SEVERE, "Unable to rollback marked or active transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
                        this.setTmNotOk(e);
                        throw (SystemException)((Object)this.logAndReturn("TM error tx rollback", (Exception)((Object)Exceptions.withCause(new SystemException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e))));
                    }
                    tx.doAfterCompletion();
                    this.txThreadMap.remove(thread);
                    try {
                        if (tx.isGlobalStartRecordWritten()) {
                            this.getTxLog().txDone(tx.getGlobalId());
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Error writing transaction log", e);
                        this.setTmNotOk(e);
                        throw (SystemException)((Object)this.logAndReturn("TM error tx rollback", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
                    }
                    tx.setStatus(6);
                    break block11;
                }
                throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
            }
            finally {
                if (hasAnyLocks) {
                    this.finishHook.finishTransaction(tx.getEventIdentifier(), false);
                }
            }
        }
    }

    public int getStatus() {
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.txThreadMap.get(Thread.currentThread());
    }

    public void resume(Transaction tx) throws IllegalStateException, SystemException {
        TransactionImpl txImpl;
        this.assertTmOk("tx resume");
        Thread thread = Thread.currentThread();
        if (this.txThreadMap.get(thread) != null) {
            throw new IllegalStateException("Transaction already associated");
        }
        if (tx != null && (txImpl = (TransactionImpl)tx).getStatus() != 6) {
            if (txImpl.isActive()) {
                throw new IllegalStateException(txImpl + " already active");
            }
            txImpl.markAsActive();
            this.txThreadMap.put(thread, txImpl);
        }
    }

    public Transaction suspend() throws SystemException {
        this.assertTmOk("tx suspend");
        TransactionImpl tx = this.txThreadMap.remove(Thread.currentThread());
        if (tx != null) {
            tx.markAsSuspended();
        }
        return tx;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.assertTmOk("tx set rollback only");
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.assertTmOk("tx set timeout");
    }

    byte[] getBranchId(XAResource xaRes) {
        byte[] branchId;
        if (xaRes instanceof XaResource && (branchId = ((XaResource)xaRes).getBranchId()) != null) {
            return branchId;
        }
        return this.xaDataSourceManager.getBranchId(xaRes);
    }

    String getTxStatusAsString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    public synchronized void dumpTransactions() {
        Iterator<TransactionImpl> itr = this.txThreadMap.values().iterator();
        if (!itr.hasNext()) {
            System.out.println("No uncompleted transactions");
            return;
        }
        System.out.println("Uncompleted transactions found: ");
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public int getEventIdentifier() {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        if (tx != null) {
            return tx.getEventIdentifier();
        }
        return -1;
    }

    @Override
    public ForceMode getForceMode() {
        return ((TransactionImpl)this.getTransaction()).getForceMode();
    }

    public int getStartedTxCount() {
        return this.startedTxCount.get();
    }

    public int getCommittedTxCount() {
        return this.comittedTxCount.get();
    }

    public int getRolledbackTxCount() {
        return this.rolledBackTxCount.get();
    }

    public int getActiveTxCount() {
        return this.txThreadMap.size();
    }

    public int getPeakConcurrentTxCount() {
        return this.peakConcurrentTransactions;
    }
}

