/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

class ReadTransaction
implements NeoStoreTransaction {
    private final NeoStore neoStore;

    public ReadTransaction(NeoStore neoStore) {
        this.neoStore = neoStore;
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    @Override
    public NodeRecord nodeLoadLight(long nodeId) {
        return this.getNodeStore().loadLightNode(nodeId);
    }

    @Override
    public RelationshipRecord relLoadLight(long id) {
        return this.getRelationshipStore().getLightRel(id);
    }

    @Override
    public long getRelationshipChainPosition(long nodeId) {
        return this.getNodeStore().getRecord(nodeId).getNextRel();
    }

    @Override
    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return ReadTransaction.getMoreRelationships(nodeId, position, this.getRelGrabSize(), this.getRelationshipStore());
    }

    static Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position, int grabSize, RelationshipStore relStore) {
        ArrayList<RelationshipRecord> out = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> in = new ArrayList<RelationshipRecord>();
        ArrayList<RelationshipRecord> loop = null;
        EnumMap result = new EnumMap(RelIdArray.DirectionWrapper.class);
        result.put(RelIdArray.DirectionWrapper.OUTGOING, out);
        result.put(RelIdArray.DirectionWrapper.INCOMING, in);
        for (int i = 0; i < grabSize && position != (long)Record.NO_NEXT_RELATIONSHIP.intValue(); ++i) {
            RelationshipRecord relRecord = relStore.getChainRecord(position);
            if (relRecord == null) {
                return Pair.of(result, position);
            }
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (relRecord.inUse()) {
                if (firstNode == secondNode) {
                    if (loop == null) {
                        loop = new ArrayList<RelationshipRecord>();
                        result.put(RelIdArray.DirectionWrapper.BOTH, loop);
                    }
                    loop.add(relRecord);
                } else if (firstNode == nodeId) {
                    out.add(relRecord);
                } else if (secondNode == nodeId) {
                    in.add(relRecord);
                }
            } else {
                --i;
            }
            if (firstNode == nodeId) {
                position = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                position = relRecord.getSecondNextRel();
                continue;
            }
            throw new InvalidRecordException("Node[" + nodeId + "] is neither firstNode[" + firstNode + "] nor secondNode[" + secondNode + "] for Relationship[" + relRecord.getId() + "]");
        }
        return Pair.of(result, position);
    }

    static List<PropertyRecord> getPropertyRecordChain(PropertyStore propertyStore, long nextProp) {
        LinkedList<PropertyRecord> toReturn = new LinkedList<PropertyRecord>();
        if (nextProp == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return null;
        }
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propertyStore.getLightRecord(nextProp);
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    static ArrayMap<Integer, PropertyData> propertyChainToMap(Collection<PropertyRecord> chain) {
        if (chain == null) {
            return null;
        }
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        for (PropertyRecord propRecord : chain) {
            for (PropertyBlock propBlock : propRecord.getPropertyBlocks()) {
                propertyMap.put(propBlock.getKeyIndexId(), propBlock.newPropertyData(propRecord));
            }
        }
        return propertyMap;
    }

    static ArrayMap<Integer, PropertyData> loadProperties(PropertyStore propertyStore, long nextProp) {
        List<PropertyRecord> chain = ReadTransaction.getPropertyRecordChain(propertyStore, nextProp);
        if (chain == null) {
            return null;
        }
        return ReadTransaction.propertyChainToMap(chain);
    }

    @Override
    public ArrayMap<Integer, PropertyData> relLoadProperties(long relId, boolean light) {
        RelationshipRecord relRecord = this.getRelationshipStore().getRecord(relId);
        if (!relRecord.inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        return ReadTransaction.loadProperties(this.getPropertyStore(), relRecord.getNextProp());
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeLoadProperties(long nodeId, boolean light) {
        return ReadTransaction.loadProperties(this.getPropertyStore(), this.getNodeStore().getRecord(nodeId).getNextProp());
    }

    @Override
    public ArrayMap<Integer, PropertyData> graphLoadProperties(boolean light) {
        return ReadTransaction.loadProperties(this.getPropertyStore(), this.neoStore.getGraphNextProp());
    }

    public Object propertyGetValueOrNull(PropertyBlock propertyBlock) {
        return propertyBlock.getType().getValue(propertyBlock, null);
    }

    @Override
    public Object loadPropertyValue(PropertyData property) {
        PropertyRecord propertyRecord = this.getPropertyStore().getRecord(property.getId());
        PropertyBlock propertyBlock = propertyRecord.getPropertyBlock(property.getIndex());
        if (propertyBlock.isLight()) {
            this.getPropertyStore().makeHeavy(propertyBlock);
        }
        return propertyBlock.getType().getValue(propertyBlock, this.getPropertyStore());
    }

    @Override
    public String loadIndex(int id) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        PropertyIndexRecord index = (PropertyIndexRecord)indexStore.getRecord(id);
        if (index.isLight()) {
            indexStore.makeHeavy(index);
        }
        return indexStore.getStringFor(index);
    }

    @Override
    public NameData[] loadPropertyIndexes(int count) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        return indexStore.getNames(count);
    }

    @Override
    public void setXaConnection(XaConnection connection) {
    }

    @Override
    public boolean delistResource(Transaction tx, int tmsuccess) throws SystemException {
        throw this.readOnlyException();
    }

    private IllegalStateException readOnlyException() {
        return new IllegalStateException("This is a read only transaction, this method should never be invoked");
    }

    @Override
    public void destroy() {
        throw this.readOnlyException();
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeDelete(long nodeId) {
        throw this.readOnlyException();
    }

    @Override
    public PropertyData nodeAddProperty(long nodeId, PropertyIndex index, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public PropertyData nodeChangeProperty(long nodeId, PropertyData data, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public void nodeRemoveProperty(long nodeId, PropertyData data) {
        throw this.readOnlyException();
    }

    @Override
    public void nodeCreate(long id) {
        throw this.readOnlyException();
    }

    @Override
    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        throw this.readOnlyException();
    }

    @Override
    public ArrayMap<Integer, PropertyData> relDelete(long relId) {
        throw this.readOnlyException();
    }

    @Override
    public PropertyData relAddProperty(long relId, PropertyIndex index, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public PropertyData relChangeProperty(long relId, PropertyData data, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public void relRemoveProperty(long relId, PropertyData data) {
        throw this.readOnlyException();
    }

    @Override
    public NameData[] loadRelationshipTypes() {
        NameData[] relTypeData = this.neoStore.getRelationshipTypeStore().getNames(Integer.MAX_VALUE);
        NameData[] rawRelTypeData = new NameData[relTypeData.length];
        for (int i = 0; i < relTypeData.length; ++i) {
            rawRelTypeData[i] = new NameData(relTypeData[i].getId(), relTypeData[i].getName());
        }
        return rawRelTypeData;
    }

    @Override
    public void createPropertyIndex(String key, int id) {
        throw this.readOnlyException();
    }

    @Override
    public void createRelationshipType(int id, String name) {
        throw this.readOnlyException();
    }

    @Override
    public RelIdArray getCreatedNodes() {
        return RelIdArray.EMPTY;
    }

    @Override
    public boolean isNodeCreated(long nodeId) {
        return false;
    }

    @Override
    public boolean isRelationshipCreated(long relId) {
        return false;
    }

    public static int getKeyIdForProperty(PropertyData property, PropertyStore store) {
        return property.getIndex();
    }

    @Override
    public int getKeyIdForProperty(PropertyData property) {
        return ReadTransaction.getKeyIdForProperty(property, this.getPropertyStore());
    }

    @Override
    public PropertyData graphAddProperty(PropertyIndex index, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public PropertyData graphChangeProperty(PropertyData index, Object value) {
        throw this.readOnlyException();
    }

    @Override
    public void graphRemoveProperty(PropertyData index) {
        throw this.readOnlyException();
    }
}

