/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.impl.util.StringLogger;

public class BaseConfigurationMigrator
implements ConfigurationMigrator {
    private List<Migration> migrations = new ArrayList<Migration>();

    public static Migration propertyRenamed(String oldKey, String newKey, String deprecationMessage) {
        return new PropertyRenamed(oldKey, newKey, deprecationMessage);
    }

    public void add(Migration migration) {
        this.migrations.add(migration);
    }

    @Override
    public Map<String, String> apply(Map<String, String> rawConfiguration, StringLogger log) {
        boolean printedDeprecationMessage = false;
        for (Migration migration : this.migrations) {
            if (!migration.appliesTo(rawConfiguration)) continue;
            if (!printedDeprecationMessage) {
                printedDeprecationMessage = true;
                log.logMessage("WARNING! Deprecated configuration options used. See manual for details");
            }
            rawConfiguration = migration.apply(rawConfiguration);
            log.logMessage(migration.getDeprecationMessage());
        }
        return rawConfiguration;
    }

    public static class PropertyRenamed
    extends SpecificPropertyMigration {
        private String newKey;

        public PropertyRenamed(String oldKey, String newKey, String deprecationMessage) {
            super(oldKey, deprecationMessage);
            this.newKey = newKey;
        }

        @Override
        public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
            rawConfiguration.put(this.newKey, value);
        }
    }

    public static abstract class SpecificPropertyMigration
    implements Migration {
        private String propertyKey;
        private String deprecationMessage;

        public SpecificPropertyMigration(String propertyKey, String deprecationMessage) {
            this.propertyKey = propertyKey;
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public boolean appliesTo(Map<String, String> rawConfiguration) {
            return rawConfiguration.containsKey(this.propertyKey);
        }

        @Override
        public Map<String, String> apply(Map<String, String> rawConfiguration) {
            String value = rawConfiguration.get(this.propertyKey);
            rawConfiguration.remove(this.propertyKey);
            this.setValueWithOldSetting(value, rawConfiguration);
            return rawConfiguration;
        }

        @Override
        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public abstract void setValueWithOldSetting(String var1, Map<String, String> var2);
    }

    public static interface Migration {
        public boolean appliesTo(Map<String, String> var1);

        public Map<String, String> apply(Map<String, String> var1);

        public String getDeprecationMessage();
    }
}

