/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;

abstract class KernelDiagnostics
implements DiagnosticsProvider {
    KernelDiagnostics() {
    }

    static void register(DiagnosticsManager manager, InternalAbstractGraphDatabase graphdb, NeoStoreXaDataSource ds) {
        manager.prependProvider(new Versions(graphdb.getClass(), ds));
        ds.registerDiagnosticsWith(manager);
        manager.appendProvider(new StoreFiles(graphdb.getStoreDir()));
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getDeclaringClass().getSimpleName() + ":" + this.getClass().getSimpleName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, StringLogger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            this.dump(log);
        }
    }

    abstract void dump(StringLogger var1);

    private static class StoreFiles
    extends KernelDiagnostics
    implements Visitor<StringLogger.LineLogger> {
        private final File storeDir;

        private StoreFiles(String storeDir) {
            this.storeDir = new File(storeDir);
        }

        @Override
        void dump(StringLogger logger) {
            logger.logLongMessage("Storage files:", this, true);
        }

        @Override
        public boolean visit(StringLogger.LineLogger logger) {
            StoreFiles.logStoreFiles(logger, "", this.storeDir);
            return false;
        }

        private static long logStoreFiles(StringLogger.LineLogger logger, String prefix, File dir) {
            if (!dir.isDirectory()) {
                return 0L;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                logger.logLine(prefix + "<INACCESSIBLE>");
                return 0L;
            }
            long total = 0L;
            for (File file : files) {
                long size;
                String filename = file.getName();
                if (file.isDirectory()) {
                    logger.logLine(prefix + filename + ":");
                    size = StoreFiles.logStoreFiles(logger, prefix + "  ", file);
                    filename = "- Total";
                } else {
                    size = file.length();
                }
                logger.logLine(prefix + filename + ": " + Format.bytes(size));
                total += size;
            }
            return total;
        }
    }

    private static class Versions
    extends KernelDiagnostics {
        private final Class<? extends GraphDatabaseService> graphDb;
        private final StoreId storeId;

        public Versions(Class<? extends GraphDatabaseService> graphDb, NeoStoreXaDataSource ds) {
            this.graphDb = graphDb;
            this.storeId = ds.getStoreId();
        }

        @Override
        void dump(StringLogger logger) {
            logger.logMessage("Graph Database: " + this.graphDb.getName() + " " + this.storeId);
            logger.logMessage("Kernel version: " + Version.getKernel());
            logger.logMessage("Neo4j component versions:");
            for (Version componentVersion : Service.load(Version.class)) {
                logger.logMessage("  " + componentVersion);
            }
        }
    }
}

