/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.lang.reflect.Field;
import java.util.Iterator;
import sun.misc.Unsafe;

public class ExceptionHandlingIterable<T>
implements Iterable<T> {
    private final Iterable<T> source;
    private static final Unsafe unsafe = ExceptionHandlingIterable.getUnsafe();

    public ExceptionHandlingIterable(Iterable<T> source) {
        this.source = source;
    }

    public static Unsafe getUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving Unsafe ", e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        try {
            final Iterator<T> it = this.source.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    try {
                        return it.hasNext();
                    }
                    catch (Throwable t) {
                        return ExceptionHandlingIterable.this.exceptionOnHasNext(t);
                    }
                }

                @Override
                public T next() {
                    try {
                        return it.next();
                    }
                    catch (Throwable t) {
                        return ExceptionHandlingIterable.this.exceptionOnNext(t);
                    }
                }

                @Override
                public void remove() {
                    try {
                        it.remove();
                    }
                    catch (Throwable t) {
                        ExceptionHandlingIterable.this.exceptionOnRemove(t);
                    }
                }
            };
        }
        catch (Throwable t) {
            return this.exceptionOnIterator(t);
        }
    }

    protected void rethrow(Throwable t) {
        unsafe.throwException(t);
    }

    protected boolean exceptionOnHasNext(Throwable t) {
        this.rethrow(t);
        return false;
    }

    protected void exceptionOnRemove(Throwable t) {
    }

    protected T exceptionOnNext(Throwable t) {
        this.rethrow(t);
        return null;
    }

    protected Iterator<T> exceptionOnIterator(Throwable t) {
        this.rethrow(t);
        return null;
    }
}

