/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexIterable;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.impl.cache.CacheProvider;

public class GraphDatabaseFactory {
    protected List<IndexProvider> indexProviders = Iterables.toList(Service.load(IndexProvider.class));
    protected List<KernelExtension> kernelExtensions = Iterables.toList(Service.load(KernelExtension.class));
    protected List<CacheProvider> cacheProviders = Iterables.toList(Service.load(CacheProvider.class));

    public GraphDatabaseService newEmbeddedDatabase(String path) {
        return this.newEmbeddedDatabaseBuilder(path).newGraphDatabase();
    }

    public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(final String path) {
        return new GraphDatabaseBuilder(new GraphDatabaseBuilder.DatabaseCreator(){

            @Override
            public GraphDatabaseService newDatabase(Map<String, String> config) {
                config.put("ephemeral", "false");
                if ("true".equalsIgnoreCase(config.get(GraphDatabaseSettings.read_only.name()))) {
                    return new EmbeddedReadOnlyGraphDatabase(path, config, GraphDatabaseFactory.this.indexProviders, GraphDatabaseFactory.this.kernelExtensions, GraphDatabaseFactory.this.cacheProviders);
                }
                return new EmbeddedGraphDatabase(path, config, GraphDatabaseFactory.this.indexProviders, GraphDatabaseFactory.this.kernelExtensions, GraphDatabaseFactory.this.cacheProviders);
            }
        });
    }

    public Iterable<IndexProvider> getIndexProviders() {
        return this.indexProviders;
    }

    public void setIndexProviders(IndexIterable indexIterable) {
        this.indexProviders.clear();
        for (IndexProvider indexProvider : indexIterable) {
            this.indexProviders.add(indexProvider);
        }
    }

    public Iterable<KernelExtension> getKernelExtension() {
        return this.kernelExtensions;
    }

    public void setKernelExtensions(Iterable<KernelExtension> newKernelExtensions) {
        this.kernelExtensions.clear();
        for (KernelExtension newKernelExtension : newKernelExtensions) {
            this.kernelExtensions.add(newKernelExtension);
        }
    }

    public void setCacheProviders(Iterable<CacheProvider> newCacheProviders) {
        this.cacheProviders.clear();
        for (CacheProvider newCacheProvider : newCacheProviders) {
            this.cacheProviders.add(newCacheProvider);
        }
    }
}

