/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.kernel.impl.traversal.TraversalBranchImpl;

public class TraversalBranchWithState
extends TraversalBranchImpl
implements BranchState {
    protected Object state;
    protected boolean stateSet;

    public TraversalBranchWithState(TraversalBranch parent, int depth, Node source, Relationship toHere) {
        super(parent, depth, source, toHere);
    }

    public TraversalBranchWithState(TraversalContext context, TraversalBranch parent, Node source) {
        super(context, parent, source);
    }

    public void setState(Object state) {
        this.state = state;
        this.stateSet = true;
    }

    public Object getState() {
        if (!this.stateSet) {
            this.state = this.retrieveStateFromParent();
            this.stateSet = true;
        }
        return this.state;
    }

    protected Object retrieveStateFromParent() {
        return ((TraversalBranchWithState)this.parent).getState();
    }

    @Override
    protected TraversalBranch newNextBranch(Node node, Relationship relationship) {
        return new TraversalBranchWithState(this, this.length() + 1, node, relationship);
    }

    @Override
    protected Iterator<Relationship> expandRelationshipsWithoutChecks(PathExpander expander) {
        return expander.expand(this, this).iterator();
    }
}

