/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.InterceptingXaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class XaFactory {
    private Config config;
    private TxIdGenerator txIdGenerator;
    private AbstractTransactionManager txManager;
    private LogBufferFactory logBufferFactory;
    private FileSystemAbstraction fileSystemAbstraction;
    private StringLogger stringLogger;
    private final RecoveryVerifier recoveryVerifier;
    private final LogPruneStrategy pruneStrategy;

    public XaFactory(Config config, TxIdGenerator txIdGenerator, AbstractTransactionManager txManager, LogBufferFactory logBufferFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, RecoveryVerifier recoveryVerifier, LogPruneStrategy pruneStrategy) {
        this.config = config;
        this.txIdGenerator = txIdGenerator;
        this.txManager = txManager;
        this.logBufferFactory = logBufferFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.stringLogger = stringLogger;
        this.recoveryVerifier = recoveryVerifier;
        this.pruneStrategy = pruneStrategy;
    }

    public XaContainer newXaContainer(XaDataSource xaDataSource, String logicalLog, XaCommandFactory cf, XaTransactionFactory tf, List<Pair<TransactionInterceptorProvider, Object>> providers, DependencyResolver dependencyResolver) {
        if (logicalLog == null || cf == null || tf == null) {
            throw new IllegalArgumentException("Null parameter, LogicalLog[" + logicalLog + "] CommandFactory[" + cf + "TransactionFactory[" + tf + "]");
        }
        XaResourceManager rm = new XaResourceManager(xaDataSource, tf, this.txIdGenerator, this.txManager, this.recoveryVerifier, logicalLog);
        XaLogicalLog log = this.config.getBoolean(Configuration.intercept_deserialized_transactions) && providers != null ? new InterceptingXaLogicalLog(logicalLog, rm, cf, tf, providers, dependencyResolver, this.logBufferFactory, this.fileSystemAbstraction, this.stringLogger, this.pruneStrategy) : new XaLogicalLog(logicalLog, rm, cf, tf, this.logBufferFactory, this.fileSystemAbstraction, this.stringLogger, this.pruneStrategy);
        rm.setLogicalLog(log);
        tf.setLogicalLog(log);
        return new XaContainer(rm, log);
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting.BooleanSetting intercept_deserialized_transactions = GraphDatabaseSettings.intercept_deserialized_transactions;
    }
}

