/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyDynamicStoreReader {
    public static final String FROM_VERSION_ARRAY = "ArrayPropertyStore v0.9.9";
    public static final String FROM_VERSION_STRING = "StringPropertyStore v0.9.9";
    private PersistenceWindowPool windowPool;
    private int blockSize;
    protected static final int BLOCK_HEADER_SIZE = 13;
    private final FileChannel fileChannel;

    public LegacyDynamicStoreReader(String fileName, String fromVersionArray) throws IOException {
        this.fileChannel = new RandomAccessFile(fileName, "r").getChannel();
        long fileSize = this.fileChannel.size();
        String expectedVersion = fromVersionArray;
        byte[] version = new byte[UTF8.encode(expectedVersion).length];
        ByteBuffer buffer = ByteBuffer.wrap(version);
        this.fileChannel.position(fileSize - (long)version.length);
        this.fileChannel.read(buffer);
        buffer = ByteBuffer.allocate(4);
        this.fileChannel.position(0L);
        this.fileChannel.read(buffer);
        buffer.flip();
        this.blockSize = buffer.getInt();
        this.windowPool = new PersistenceWindowPool(fileName, this.blockSize, this.fileChannel, 0L, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LegacyDynamicRecord> getPropertyChain(long startBlockId) {
        LinkedList<LegacyDynamicRecord> recordList = new LinkedList<LegacyDynamicRecord>();
        long blockId = startBlockId;
        while (blockId != (long)Record.NO_NEXT_BLOCK.intValue()) {
            PersistenceWindow window = this.windowPool.acquire(blockId, OperationType.READ);
            try {
                LegacyDynamicRecord record = this.getRecord(blockId, window);
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            finally {
                this.windowPool.release(window);
            }
        }
        return recordList;
    }

    private LegacyDynamicRecord getRecord(long blockId, PersistenceWindow window) {
        long nextModifier;
        boolean inUse;
        LegacyDynamicRecord record = new LegacyDynamicRecord(blockId);
        Buffer buffer = window.getOffsettedBuffer(blockId);
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (!inUse) {
            throw new InvalidRecordException("Not in use, blockId[" + blockId + "]");
        }
        long prevBlock = buffer.getUnsignedInt();
        long prevModifier = (inUseByte & 0xF0L) << 28;
        int dataSize = this.blockSize - 13;
        long nrOfBytesInt = buffer.getInt();
        int nrOfBytes = (int)(nrOfBytesInt & 0xFFFFFFL);
        long nextBlock = buffer.getUnsignedInt();
        long longNextBlock = LegacyStore.longFromIntAndMod(nextBlock, nextModifier = (nrOfBytesInt & 0xF000000L) << 8);
        if (longNextBlock != (long)Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
            throw new InvalidRecordException("Next block set[" + nextBlock + "] current block illegal size[" + nrOfBytes + "/" + dataSize + "]");
        }
        record.setInUse(true);
        record.setLength(nrOfBytes);
        record.setPrevBlock(LegacyStore.longFromIntAndMod(prevBlock, prevModifier));
        record.setNextBlock(longNextBlock);
        byte[] byteArrayElement = new byte[nrOfBytes];
        buffer.get(byteArrayElement);
        record.setData(byteArrayElement);
        return record;
    }

    public static Object getRightArray(byte[] bArray) {
        ByteBuffer buf = ByteBuffer.wrap(bArray);
        byte type = buf.get();
        if (type == ArrayType.INT.byteValue()) {
            int size = (bArray.length - 1) / 4;
            assert ((bArray.length - 1) % 4 == 0);
            int[] array = new int[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getInt();
            }
            return array;
        }
        if (type == ArrayType.STRING.byteValue()) {
            String[] array = new String[buf.getInt()];
            for (int i = 0; i < array.length; ++i) {
                int charLength = buf.getInt() / 2;
                char[] charBuffer = new char[charLength];
                for (int j = 0; j < charLength; ++j) {
                    charBuffer[j] = buf.getChar();
                }
                array[i] = new String(charBuffer);
            }
            return array;
        }
        if (type == ArrayType.BOOL.byteValue()) {
            boolean[] array = new boolean[buf.getInt()];
            int byteItr = 1;
            byte currentValue = buf.get();
            for (int i = 0; i < array.length; ++i) {
                boolean bl = array[i] = (currentValue & byteItr) > 0;
                if ((byteItr *= 2) != 256) continue;
                byteItr = 0;
                currentValue = buf.get();
            }
            return array;
        }
        if (type == ArrayType.DOUBLE.byteValue()) {
            int size = (bArray.length - 1) / 8;
            assert ((bArray.length - 1) % 8 == 0);
            double[] array = new double[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getDouble();
            }
            return array;
        }
        if (type == ArrayType.FLOAT.byteValue()) {
            int size = (bArray.length - 1) / 4;
            assert ((bArray.length - 1) % 4 == 0);
            float[] array = new float[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getFloat();
            }
            return array;
        }
        if (type == ArrayType.LONG.byteValue()) {
            int size = (bArray.length - 1) / 8;
            assert ((bArray.length - 1) % 8 == 0);
            long[] array = new long[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getLong();
            }
            return array;
        }
        if (type == ArrayType.BYTE.byteValue()) {
            int size = bArray.length - 1;
            byte[] array = new byte[size];
            buf.get(array);
            return array;
        }
        if (type == ArrayType.CHAR.byteValue()) {
            int size = (bArray.length - 1) / 2;
            assert ((bArray.length - 1) % 2 == 0);
            char[] array = new char[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getChar();
            }
            return array;
        }
        if (type == ArrayType.SHORT.byteValue()) {
            int size = (bArray.length - 1) / 2;
            assert ((bArray.length - 1) % 2 == 0);
            short[] array = new short[size];
            for (int i = 0; i < size; i = (int)((short)(i + 1))) {
                array[i] = buf.getShort();
            }
            return array;
        }
        throw new InvalidRecordException("Unknown array type[" + type + "]");
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }

    private static enum ArrayType {
        ILLEGAL(0),
        INT(1),
        STRING(2),
        BOOL(3),
        DOUBLE(4),
        FLOAT(5),
        LONG(6),
        BYTE(7),
        CHAR(8),
        SHORT(10);

        private int type;

        private ArrayType(int type) {
            this.type = type;
        }

        public byte byteValue() {
            return (byte)this.type;
        }
    }
}

