/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Set;
import org.neo4j.graphdb.factory.SettingsResourceBundle;

public class ConfigAsciiDocGenerator {
    public String generateDocsFor(Class<? extends SettingsResourceBundle> settingsResource) {
        ResourceBundle bundle = ResourceBundle.getBundle(settingsResource.getName());
        StringBuilder sb = new StringBuilder();
        Set<String> keys = bundle.keySet();
        for (String property : keys) {
            if (!property.endsWith(".description")) continue;
            String name = property.substring(0, property.lastIndexOf("."));
            sb.append("." + bundle.getString(name + ".title") + "\n");
            String minmax = "";
            if (bundle.containsKey(name + ".min") && bundle.containsKey(name + ".max")) {
                minmax = ",\"minmax\"";
            } else if (bundle.containsKey(name + ".min")) {
                minmax = ",\"min\"";
            } else if (bundle.containsKey(name + ".max")) {
                minmax = ",\"max\"";
            }
            sb.append("[\"configsetting\"" + minmax + "]\n");
            sb.append("----\n");
            String defaultKey = name + ".default";
            if (bundle.containsKey(defaultKey)) {
                sb.append(name + ": " + bundle.getString(defaultKey) + "\n");
            } else {
                sb.append(name + "\n");
            }
            sb.append(bundle.getString(property) + "\n");
            String optionsKey = name + ".options";
            if (bundle.containsKey(optionsKey)) {
                String[] options = bundle.getString(optionsKey).split(",");
                if (bundle.containsKey(name + ".option." + options[0])) {
                    for (String option : options) {
                        String description = bundle.getString(name + ".option." + option);
                        char[] spaces = new char[option.length() + 2];
                        Arrays.fill(spaces, ' ');
                        description = description.replace("\n", " ");
                        sb.append(option + ": " + description + "\n");
                    }
                } else {
                    sb.append(bundle.getString(optionsKey).replace(",", "\u00a0\n") + "\n");
                }
            }
            if (bundle.containsKey(name + ".min")) {
                sb.append(bundle.getString(name + ".min") + "\n");
            }
            if (bundle.containsKey(name + ".max")) {
                sb.append(bundle.getString(name + ".max") + "\n");
            }
            sb.append("----\n");
            sb.append("\n");
        }
        return sb.toString();
    }
}

