/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.logging.BufferingLogger;

public class Config
implements DiagnosticsProvider {
    private final List<ConfigurationChangeListener> listeners = new ArrayList<ConfigurationChangeListener>();
    private final Map<String, String> params = new HashMap<String, String>();
    private final ConfigurationMigrator migrator;
    private StringLogger log = new BufferingLogger();
    private final ConfigurationValidator validator;
    @Deprecated
    static final String NIO_NEO_DB_CLASS = "org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource";
    @Deprecated
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    @Deprecated
    static final String LUCENE_DS_CLASS = "org.neo4j.index.lucene.LuceneDataSource";
    @Deprecated
    static final String LUCENE_FULLTEXT_DS_CLASS = "org.neo4j.index.lucene.LuceneFulltextDataSource";
    @Documented(value=" Tell Neo4j to use memory mapped buffers for accessing the native storage\n layer\n")
    @Deprecated
    public static final String USE_MEMORY_MAPPED_BUFFERS = "use_memory_mapped_buffers";
    @Documented(value="Print out the effective Neo4j configuration after startup ")
    @Deprecated
    public static final String DUMP_CONFIGURATION = "dump_configuration";
    @Documented(value=" Make Neo4j keep the logical transaction logs for being able to backup the\n database. Provides control over how much disk space logical logs are allowed\n to take per data source.\n")
    @Deprecated
    public static final String KEEP_LOGICAL_LOGS = "keep_logical_logs";
    @Documented(value="Enable a remote shell server which shell clients can log in to ")
    @Deprecated
    public static final String ENABLE_REMOTE_SHELL = "enable_remote_shell";
    @Documented(value="Enable a support for running online backups ")
    @Deprecated
    public static final String ENABLE_ONLINE_BACKUP = "enable_online_backup";
    @Documented(value="Mark this database as a backup slave. ")
    @Deprecated
    public static final String BACKUP_SLAVE = "backup_slave";
    @Documented(value="Only allow read operations from this Neo4j instance. ")
    @Deprecated
    public static final String READ_ONLY = "read_only";
    @Documented(value="Relative path for where the Neo4j storage directory is located ")
    @Deprecated
    public static final String STORAGE_DIRECTORY = "store_dir";
    @Documented(value=" Use a quick approach for rebuilding the ID generators. This give quicker\n recovery time, but will limit the ability to reuse the space of deleted\n entities.\n")
    @Deprecated
    public static final String REBUILD_IDGENERATORS_FAST = "rebuild_idgenerators_fast";
    @Documented(value="The size to allocate for memory mapping the node store ")
    @Deprecated
    public static final String NODE_STORE_MMAP_SIZE = "neostore.nodestore.db.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the array property store ")
    @Deprecated
    public static final String ARRAY_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.arrays.mapped_memory";
    @Documented(value=" The size to allocate for memory mapping the store for property key\n strings\n")
    @Deprecated
    public static final String PROPERTY_INDEX_KEY_STORE_MMAP_SIZE = "neostore.propertystore.db.index.keys.mapped_memory";
    @Documented(value=" The size to allocate for memory mapping the store for property key\n indexes\n")
    @Deprecated
    public static final String PROPERTY_INDEX_STORE_MMAP_SIZE = "neostore.propertystore.db.index.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the property value store ")
    @Deprecated
    public static final String PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the string property store ")
    @Deprecated
    public static final String STRING_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.strings.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the relationship store ")
    @Deprecated
    public static final String RELATIONSHIP_STORE_MMAP_SIZE = "neostore.relationshipstore.db.mapped_memory";
    @Documented(value="Relative path for where the Neo4j logical log is located ")
    @Deprecated
    public static final String LOGICAL_LOG = "logical_log";
    @Documented(value="Relative path for where the Neo4j storage information file is located ")
    @Deprecated
    public static final String NEO_STORE = "neo_store";
    @Documented(value=" The type of cache to use for nodes and relationships, one of [weak, soft,\n none, array]\n")
    @Deprecated
    public static final String CACHE_TYPE = "cache_type";
    @Documented(value=" The amount of memory to use for the node cache (when using the 'gcr' cache).\n")
    @Deprecated
    public static final String NODE_CACHE_SIZE = "node_cache_size";
    @Documented(value=" The amount of memory to use for the relationship cache (when using the 'gcr' cache).\n")
    @Deprecated
    public static final String RELATIONSHIP_CACHE_SIZE = "relationship_cache_size";
    @Documented(value=" The fraction of the heap (1%-10%) to use for the base array in the node cache (when using the 'gcr' cache).\n")
    @Deprecated
    public static final String NODE_CACHE_ARRAY_FRACTION = "node_cache_array_fraction";
    @Documented(value=" The fraction of the heap (1%-10%) to use for the base array in the relationship cache (when using the 'gcr' cache).\n")
    @Deprecated
    public static final String RELATIONSHIP_CACHE_ARRAY_FRACTION = "relationship_cache_array_fraction";
    @Documented(value=" The minimal time that must pass in between logging statistics from the cache (when using the 'gcr' cache).\n Default unit is seconds, suffix with 's', 'm', or 'ms' to have the unit be seconds, minutes or milliseconds respectively.\n")
    @Deprecated
    public static final String GCR_CACHE_MIN_LOG_INTERVAL = "gcr_cache_min_log_interval";
    @Documented(value=" The name of the Transaction Manager service to use as defined in the TM\n service provider constructor, defaults to native.\n")
    @Deprecated
    public static final String TXMANAGER_IMPLEMENTATION = "tx_manager_impl";
    @Documented(value=" Determines whether any TransactionInterceptors loaded will intercept\n prepared transactions before they reach the logical log. Defaults to\n false.\n")
    @Deprecated
    public static final String INTERCEPT_COMMITTING_TRANSACTIONS = "intercept_committing_transactions";
    @Documented(value=" Determines whether any TransactionInterceptors loaded will intercept\n externally received transactions (e.g. in HA) before they reach the\n logical log and are applied to the store. Defaults to false.\n")
    @Deprecated
    public static final String INTERCEPT_DESERIALIZED_TRANSACTIONS = "intercept_deserialized_transactions";
    @Documented(value=" Boolean (one of true,false) defining whether to allow a store upgrade\n in case the current version of the database starts against an older store\n version. Setting this to true does not guarantee successful upgrade, just\n allows an attempt at it.\n")
    @Deprecated
    public static final String ALLOW_STORE_UPGRADE = "allow_store_upgrade";
    @Deprecated
    public static final String STRING_BLOCK_SIZE = "string_block_size";
    @Deprecated
    public static final String ARRAY_BLOCK_SIZE = "array_block_size";
    @Documented(value=" A list of property names (comma separated) that will be indexed by\n default.\n This applies to Nodes only.\n")
    @Deprecated
    public static final String NODE_KEYS_INDEXABLE = "node_keys_indexable";
    @Documented(value=" A list of property names (comma separated) that will be indexed by\n default.\n This applies to Relationships only.\n")
    @Deprecated
    public static final String RELATIONSHIP_KEYS_INDEXABLE = "relationship_keys_indexable";
    @Documented(value=" Boolean value (one of true, false) that controls the auto indexing\n feature for nodes. Setting to false shuts it down unconditionally,\n while true enables it for every property, subject to restrictions\n in the configuration.\n The default is false.\n")
    @Deprecated
    public static final String NODE_AUTO_INDEXING = "node_auto_indexing";
    @Documented(value=" Boolean value (one of true, false) that controls the auto indexing\n feature for relationships. Setting to false shuts it down\n unconditionally, while true enables it for every property, subject\n to restrictions in the configuration.\n The default is false.\n")
    @Deprecated
    public static final String RELATIONSHIP_AUTO_INDEXING = "relationship_auto_indexing";
    @Documented(value=" Integer value that sets the maximum number of open lucene index searchers.\n The default is Integer.MAX_VALUE\n")
    @Deprecated
    public static final String LUCENE_SEARCHER_CACHE_SIZE = "lucene_searcher_cache_size";
    @Documented(value=" Integer value that sets the maximum number of open lucene index writers.\n The default is Integer.MAX_VALUE\n")
    @Deprecated
    public static final String LUCENE_WRITER_CACHE_SIZE = "lucene_writer_cache_size";
    @Documented(value=" Amount of time in ms the GC monitor thread will wait before taking another measurement.\n Default is 100 ms.\n")
    @Deprecated
    public static final String GC_MONITOR_WAIT_TIME = "gc_monitor_wait_time";
    @Documented(value=" The amount of time in ms the monitor thread has to be blocked before logging a message it was blocked.\n Default is 200ms\n")
    @Deprecated
    public static final String GC_MONITOR_THRESHOLD = "gc_monitor_threshold";
    @Deprecated
    static final String LOAD_EXTENSIONS = "load_kernel_extensions";

    public Config() {
        this(new HashMap<String, String>(), Collections.emptyList());
    }

    public Config(Map<String, String> inputParams) {
        this(inputParams, Collections.emptyList());
    }

    public Config(Map<String, String> inputParams, Class<?> ... settingsClasses) {
        this(inputParams, Iterables.iterable(settingsClasses));
    }

    public Config(Map<String, String> inputParams, Iterable<Class<?>> settingsClasses) {
        this.migrator = new AnnotationBasedConfigurationMigrator(settingsClasses);
        this.validator = new ConfigurationValidator(settingsClasses);
        this.applyChanges(new ConfigurationDefaults(settingsClasses).apply(inputParams));
    }

    public Map<String, String> getParams() {
        return new HashMap<String, String>(this.params);
    }

    public Collection<String> getKeys() {
        return this.params.keySet();
    }

    public boolean isSet(GraphDatabaseSetting<?> graphDatabaseSetting) {
        return this.params.containsKey(graphDatabaseSetting.name()) && this.params.get(graphDatabaseSetting.name()) != null;
    }

    public <T> T get(GraphDatabaseSetting<T> setting) {
        String string = this.params.get(setting.name());
        if (string != null) {
            string = string.trim();
        }
        return setting.valueOf(string, this);
    }

    public synchronized void applyChanges(Map<String, String> newConfiguration) {
        newConfiguration = this.migrator.apply(newConfiguration, this.log);
        this.validator.validate(newConfiguration);
        if (this.listeners.isEmpty()) {
            this.params.clear();
            this.params.putAll(newConfiguration);
        } else {
            ArrayList<ConfigurationChange> configurationChanges = new ArrayList<ConfigurationChange>();
            for (Map.Entry<String, String> stringStringEntry : newConfiguration.entrySet()) {
                String oldValue = this.params.get(stringStringEntry.getKey());
                String newValue = stringStringEntry.getValue();
                if (oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue)) continue;
                configurationChanges.add(new ConfigurationChange(stringStringEntry.getKey(), oldValue, newValue));
            }
            this.params.clear();
            this.params.putAll(newConfiguration);
            for (ConfigurationChangeListener listener : this.listeners) {
                listener.notifyConfigurationChanges(configurationChanges);
            }
        }
    }

    public void setLogger(StringLogger log) {
        if (this.log instanceof BufferingLogger) {
            ((BufferingLogger)this.log).replayInto(log);
        }
        this.log = log;
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, StringLogger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            log.logLongMessage("Neo4j Kernel properties:", Iterables.map(new Function<Map.Entry<String, String>, String>(){

                @Override
                public String map(Map.Entry<String, String> stringStringEntry) {
                    return stringStringEntry.getKey() + "=" + stringStringEntry.getValue();
                }
            }, this.params.entrySet()));
        }
    }

    public String toString() {
        ArrayList<String> keys = new ArrayList<String>(this.params.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (String key : keys) {
            output.put(key, this.params.get(key));
        }
        return output.toString();
    }

    @Deprecated
    public boolean getBoolean(GraphDatabaseSetting.BooleanSetting setting) {
        return this.get(setting);
    }

    @Deprecated
    public int getInteger(GraphDatabaseSetting.IntegerSetting setting) {
        return this.get(setting);
    }

    @Deprecated
    public long getLong(GraphDatabaseSetting.LongSetting setting) {
        return this.get(setting);
    }

    @Deprecated
    public double getDouble(GraphDatabaseSetting.DoubleSetting setting) {
        return this.get(setting);
    }

    @Deprecated
    public float getFloat(GraphDatabaseSetting.FloatSetting setting) {
        return this.get(setting).floatValue();
    }

    @Deprecated
    public long getSize(GraphDatabaseSetting.StringSetting setting) {
        return Config.parseLongWithUnit(this.get(setting));
    }

    public static long parseLongWithUnit(String numberWithPotentialUnit) {
        numberWithPotentialUnit = numberWithPotentialUnit.toLowerCase();
        long multiplier = 1L;
        if (numberWithPotentialUnit.endsWith("k")) {
            multiplier = 1024L;
            numberWithPotentialUnit = numberWithPotentialUnit.substring(0, numberWithPotentialUnit.length() - 1);
        } else if (numberWithPotentialUnit.endsWith("m")) {
            multiplier = 0x100000L;
            numberWithPotentialUnit = numberWithPotentialUnit.substring(0, numberWithPotentialUnit.length() - 1);
        } else if (numberWithPotentialUnit.endsWith("g")) {
            multiplier = 0x40000000L;
            numberWithPotentialUnit = numberWithPotentialUnit.substring(0, numberWithPotentialUnit.length() - 1);
        }
        return Long.parseLong(numberWithPotentialUnit) * multiplier;
    }

    @Deprecated
    public long getDuration(GraphDatabaseSetting.StringSetting setting) {
        return TimeUtil.parseTimeMillis(this.get(setting));
    }

    @Deprecated
    public <T extends Enum<T>> T getEnum(Class<T> enumType, GraphDatabaseSetting.OptionsSetting graphDatabaseSetting) {
        return Enum.valueOf(enumType, this.get(graphDatabaseSetting));
    }
}

