/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class InterceptingXaLogicalLog
extends XaLogicalLog {
    private final XaDataSource ds;
    private final List<Pair<TransactionInterceptorProvider, Object>> providers;
    private final DependencyResolver dependencyResolver;

    public InterceptingXaLogicalLog(String fileName, XaResourceManager xaRm, XaCommandFactory cf, XaTransactionFactory xaTf, List<Pair<TransactionInterceptorProvider, Object>> providers, DependencyResolver dependencyResolver, LogBufferFactory logBufferFactory, FileSystemAbstraction fileSystem, StringLogger stringLogger) {
        super(fileName, xaRm, cf, xaTf, logBufferFactory, fileSystem, stringLogger);
        this.providers = providers;
        this.dependencyResolver = dependencyResolver;
        this.ds = xaRm.getDataSource();
    }

    @Override
    protected XaLogicalLog.LogDeserializer getLogDeserializer(ReadableByteChannel byteChannel) {
        final TransactionInterceptor interceptor = TransactionInterceptorProvider.resolveChain(this.providers, this.ds, this.dependencyResolver);
        XaLogicalLog.LogDeserializer toReturn = new XaLogicalLog.LogDeserializer(byteChannel){

            @Override
            protected void intercept(List<LogEntry> entries) {
                for (LogEntry entry : entries) {
                    if (entry instanceof LogEntry.Command) {
                        LogEntry.Command commandEntry = (LogEntry.Command)entry;
                        if (!(commandEntry.getXaCommand() instanceof Command)) continue;
                        ((Command)commandEntry.getXaCommand()).accept(interceptor);
                        continue;
                    }
                    if (entry instanceof LogEntry.Start) {
                        interceptor.setStartEntry((LogEntry.Start)entry);
                        continue;
                    }
                    if (!(entry instanceof LogEntry.Commit)) continue;
                    interceptor.setCommitEntry((LogEntry.Commit)entry);
                }
                interceptor.complete();
            }
        };
        return toReturn;
    }
}

