/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import org.neo4j.kernel.Lifecycle;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class NioNeoDbPersistenceSource
implements PersistenceSource,
EntityIdGenerator,
Lifecycle {
    private NeoStoreXaDataSource xaDs = null;
    private String dataSourceName = null;
    private NeoStoreTransaction readOnlyResourceConnection;
    private XaDataSourceManager xaDataSourceManager;

    public NioNeoDbPersistenceSource(XaDataSourceManager xaDataSourceManager) {
        assert (xaDataSourceManager != null);
        this.xaDataSourceManager = xaDataSourceManager;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
        this.xaDs = this.xaDataSourceManager.getNeoStoreDataSource();
        if (this.xaDs == null) {
            throw new IllegalStateException("Unable to get nioneodb datasource");
        }
        this.readOnlyResourceConnection = new ReadTransaction(this.xaDs.getNeoStore());
    }

    @Override
    public void stop() {
        if (this.xaDs != null) {
            // empty if block
        }
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    public NeoStoreTransaction createTransaction(XaConnection connection) {
        if (this.xaDs.isReadOnly()) {
            throw new ReadOnlyDbException();
        }
        WriteTransaction result = ((NeoStoreXaConnection)connection).getWriteTransaction();
        result.setXaConnection(connection);
        return result;
    }

    public NeoStoreTransaction createReadOnlyResourceConnection() {
        return this.readOnlyResourceConnection;
    }

    public String toString() {
        return "A persistence source to [" + this.dataSourceName + "]";
    }

    @Override
    public long nextId(Class<?> clazz) {
        return this.xaDs.nextId(clazz);
    }

    @Override
    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.xaDs.getHighestPossibleIdInUse(clazz);
    }

    @Override
    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.xaDs.getNumberOfIdsInUse(clazz);
    }

    @Override
    public XaDataSource getXaDataSource() {
        return this.xaDs;
    }
}

