/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.Lifecycle;
import org.neo4j.kernel.LifecycleException;
import org.neo4j.kernel.impl.util.StringLogger;

public class LifeSupport
implements Lifecycle {
    List<LifecycleInstance> instances = new ArrayList<LifecycleInstance>();
    Status status = Status.NONE;

    public <T> T add(T instance) {
        if (instance instanceof Lifecycle) {
            this.instances.add(new LifecycleInstance((Lifecycle)instance));
        }
        return instance;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    @Override
    public synchronized void init() throws LifecycleException {
        if (this.status == Status.NONE) {
            this.status = Status.INITIALIZING;
            for (LifecycleInstance instance : this.instances) {
                try {
                    instance.init();
                }
                catch (LifecycleException e) {
                    this.status = Status.STOPPED;
                    try {
                        this.shutdown();
                    }
                    catch (LifecycleException e1) {
                        throw this.causedBy(e1, e);
                    }
                    throw e;
                }
            }
            this.status = Status.STOPPED;
        }
    }

    @Override
    public synchronized void start() throws LifecycleException {
        this.init();
        if (this.status == Status.STOPPED) {
            this.status = Status.STARTING;
            for (LifecycleInstance instance : this.instances) {
                try {
                    instance.start();
                }
                catch (LifecycleException e) {
                    this.status = Status.STARTED;
                    try {
                        this.stop();
                    }
                    catch (LifecycleException e1) {
                        throw this.causedBy(e1, e);
                    }
                    throw e;
                }
            }
            this.status = Status.STARTED;
        }
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (this.status == Status.STARTED) {
            this.status = Status.STOPPING;
            LifecycleException ex = null;
            for (int i = this.instances.size() - 1; i >= 0; --i) {
                LifecycleInstance lifecycleInstance = this.instances.get(i);
                try {
                    lifecycleInstance.stop();
                    continue;
                }
                catch (LifecycleException e) {
                    ex = this.causedBy(e, ex);
                }
            }
            this.status = Status.STOPPED;
            if (ex != null) {
                throw ex;
            }
        }
    }

    @Override
    public synchronized void shutdown() throws LifecycleException {
        LifecycleException ex = null;
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            ex = e;
        }
        if (this.status == Status.STOPPED) {
            this.status = Status.SHUTTING_DOWN;
            for (int i = this.instances.size() - 1; i >= 0; --i) {
                LifecycleInstance lifecycleInstance = this.instances.get(i);
                try {
                    lifecycleInstance.shutdown();
                    continue;
                }
                catch (LifecycleException e) {
                    ex = this.causedBy(e, ex);
                }
            }
            this.status = Status.SHUTDOWN;
            if (ex != null) {
                throw ex;
            }
        }
    }

    public synchronized void restart(Lifecycle instance) throws LifecycleException, IllegalArgumentException {
        if (this.status == Status.STARTED) {
            int i;
            boolean foundRestartingInstance = false;
            ArrayList<LifecycleInstance> restartingInstances = new ArrayList<LifecycleInstance>();
            for (LifecycleInstance lifecycleInstance : this.instances) {
                if (lifecycleInstance.instance == instance) {
                    foundRestartingInstance = true;
                }
                if (!foundRestartingInstance) continue;
                restartingInstances.add(lifecycleInstance);
            }
            if (!foundRestartingInstance) {
                throw new IllegalArgumentException("Instance is not registered");
            }
            this.status = Status.STOPPING;
            LifecycleException ex = null;
            for (i = restartingInstances.size() - 1; i >= 0; --i) {
                LifecycleInstance lifecycleInstance = (LifecycleInstance)restartingInstances.get(i);
                try {
                    lifecycleInstance.stop();
                    continue;
                }
                catch (LifecycleException e) {
                    ex = this.causedBy(e, ex);
                }
            }
            if (ex != null) {
                this.status = Status.STARTED;
                try {
                    this.stop();
                    throw ex;
                }
                catch (LifecycleException e) {
                    throw this.causedBy(e, ex);
                }
            }
            try {
                for (i = 0; i < restartingInstances.size(); ++i) {
                    LifecycleInstance lifecycle = (LifecycleInstance)restartingInstances.get(i);
                    lifecycle.start();
                }
                this.status = Status.STARTED;
            }
            catch (LifecycleException e) {
                this.status = Status.STARTED;
                try {
                    this.stop();
                    throw e;
                }
                catch (LifecycleException e1) {
                    throw this.causedBy(e1, e);
                }
            }
        }
    }

    public synchronized void dump(StringLogger logger) {
        logger.logLongMessage("Lifecycle status:" + this.status.name(), new Visitor<StringLogger.LineLogger>(){

            @Override
            public boolean visit(StringLogger.LineLogger element) {
                for (LifecycleInstance instance : LifeSupport.this.instances) {
                    element.logLine(instance.toString());
                }
                return true;
            }
        }, true);
    }

    private LifecycleException causedBy(LifecycleException exception, LifecycleException chainedLifecycleException) {
        if (chainedLifecycleException == null) {
            return exception;
        }
        Throwable current = exception;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        current.initCause(chainedLifecycleException);
        return exception;
    }

    private static class LifecycleInstance
    implements Lifecycle {
        Lifecycle instance;
        Status currentStatus = Status.NONE;

        private LifecycleInstance(Lifecycle instance) {
            this.instance = instance;
        }

        @Override
        public void init() throws LifecycleException {
            if (this.currentStatus == Status.NONE) {
                this.currentStatus = Status.INITIALIZING;
                try {
                    this.instance.init();
                    this.currentStatus = Status.STOPPED;
                }
                catch (Throwable e) {
                    this.currentStatus = Status.NONE;
                    throw new LifecycleException(this.instance, Status.NONE, Status.STOPPED, e);
                }
            }
        }

        @Override
        public void start() throws LifecycleException {
            if (this.currentStatus == Status.STOPPED) {
                this.currentStatus = Status.STARTING;
                try {
                    this.instance.start();
                    this.currentStatus = Status.STARTED;
                }
                catch (Throwable e) {
                    this.currentStatus = Status.STOPPED;
                    throw new LifecycleException(this.instance, Status.STOPPED, Status.STARTED, e);
                }
            }
        }

        @Override
        public void stop() throws LifecycleException {
            if (this.currentStatus == Status.STARTED) {
                this.currentStatus = Status.STOPPING;
                try {
                    this.instance.stop();
                }
                catch (Throwable e) {
                    throw new LifecycleException(this.instance, Status.STARTED, Status.STOPPED, e);
                }
                finally {
                    this.currentStatus = Status.STOPPED;
                }
            }
        }

        @Override
        public void shutdown() throws LifecycleException {
            if (this.currentStatus == Status.STOPPED) {
                this.currentStatus = Status.SHUTTING_DOWN;
                try {
                    this.instance.shutdown();
                }
                catch (Throwable e) {
                    throw new LifecycleException(this.instance, Status.STOPPED, Status.SHUTTING_DOWN, e);
                }
                finally {
                    this.currentStatus = Status.SHUTDOWN;
                }
            }
        }

        public String toString() {
            return this.instance.toString() + ": " + this.currentStatus.name();
        }
    }

    public static enum Status {
        NONE,
        INITIALIZING,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

