/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.transaction.LockManager;

public enum LockType {
    READ{

        @Override
        public void acquire(Object resource, LockManager lockManager) {
            lockManager.getReadLock(resource);
        }

        @Override
        public void unacquire(Object resource, LockManager lockManager, LockReleaser lockReleaser) {
            lockManager.releaseReadLock(resource, null);
        }

        @Override
        public void release(Object resource, LockManager lockManager) {
            lockManager.releaseReadLock(resource, null);
        }
    }
    ,
    WRITE{

        @Override
        public void acquire(Object resource, LockManager lockManager) {
            lockManager.getWriteLock(resource);
        }

        @Override
        public void unacquire(Object resource, LockManager lockManager, LockReleaser lockReleaser) {
            lockReleaser.addLockToTransaction(resource, this);
        }

        @Override
        public void release(Object resource, LockManager lockManager) {
            lockManager.releaseWriteLock(resource, null);
        }
    };


    public abstract void acquire(Object var1, LockManager var2);

    public abstract void unacquire(Object var1, LockManager var2, LockReleaser var3);

    public abstract void release(Object var1, LockManager var2);
}

