/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;

public enum ShortString {
    NUMERICAL(15, 15, 4){

        @Override
        int encTranslate(byte b) {
            if (b >= 48 && b <= 57) {
                return b - 48;
            }
            switch (b) {
                case 0: {
                    return 10;
                }
                case 2: {
                    return 11;
                }
                case 3: {
                    return 12;
                }
                case 6: {
                    return 13;
                }
                case 7: {
                    return 14;
                }
                case 8: {
                    return 15;
                }
            }
            throw this.cannotEncode(b);
        }

        @Override
        int encPunctuation(byte b) {
            throw this.cannotEncode(b);
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint < 10) {
                return (char)(codePoint + 48);
            }
            return this.decPunctuation(codePoint - 10 + 6);
        }

        @Override
        long header(int length) {
            if (length == this.max) {
                return 16L;
            }
            return length;
        }
    }
    ,
    UPPER(12, 31, 5){

        @Override
        int encTranslate(byte b) {
            return super.encTranslate(b) - 64;
        }

        @Override
        int encPunctuation(byte b) {
            return b == 0 ? 64 : b + 90;
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint == 0) {
                return ' ';
            }
            if (codePoint <= 26) {
                return (char)(codePoint + 65 - 1);
            }
            return this.decPunctuation(codePoint - 26);
        }

        @Override
        long header(int length) {
            if (length == this.max) {
                return 96L;
            }
            return (0x20 | length) << 1;
        }
    }
    ,
    LOWER(12, 31, 5){

        @Override
        int encTranslate(byte b) {
            return super.encTranslate(b) - 96;
        }

        @Override
        int encPunctuation(byte b) {
            return b == 0 ? 96 : b + 122;
        }

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint == 0) {
                return ' ';
            }
            if (codePoint <= 26) {
                return (char)(codePoint + 97 - 1);
            }
            return this.decPunctuation(codePoint - 26);
        }

        @Override
        long header(int length) {
            if (length == this.max) {
                return 160L;
            }
            return (0x40 | length) << 1;
        }
    }
    ,
    ALPHANUM(10, 63, 6){

        @Override
        char decTranslate(byte codePoint) {
            return EUROPEAN.decTranslate((byte)(codePoint + 64));
        }

        @Override
        int encTranslate(byte b) {
            if (b < 32) {
                return this.encPunctuation(b);
            }
            return EUROPEAN.encTranslate(b) - 64;
        }

        @Override
        int encPunctuation(byte b) {
            switch (b) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 32;
                }
            }
            throw this.cannotEncode(b);
        }

        @Override
        long header(int length) {
            return 384L;
        }
    }
    ,
    EUROPEAN(9, 127, 7){

        @Override
        char decTranslate(byte codePoint) {
            if (codePoint < 64) {
                if (codePoint == 23) {
                    return '.';
                }
                if (codePoint == 55) {
                    return '-';
                }
                return (char)(codePoint + 192);
            }
            if (codePoint == 64) {
                return ' ';
            }
            if (codePoint == 96) {
                return '_';
            }
            if (codePoint >= 91 && codePoint < 96) {
                return (char)(48 + codePoint - 91);
            }
            if (codePoint >= 123 && codePoint < 128) {
                return (char)(53 + codePoint - 123);
            }
            return (char)codePoint;
        }

        @Override
        int encPunctuation(byte b) {
            switch (b) {
                case 0: {
                    return 64;
                }
                case 1: {
                    return 96;
                }
                case 2: {
                    return 23;
                }
                case 3: {
                    return 55;
                }
            }
            throw this.cannotEncode(b);
        }

        @Override
        long header(int length) {
            if (length == this.max) {
                return 128L;
            }
            return 0x70 | length - 1;
        }
    };

    final int max;
    final short mask;
    final short step;
    private static final char[] PUNCTUATION;

    private ShortString(int max, int mask, int step) {
        this.max = max;
        this.mask = (short)mask;
        this.step = (short)step;
    }

    final IllegalArgumentException cannotEncode(byte b) {
        return new IllegalArgumentException("Cannot encode as " + this.name() + ": " + b);
    }

    final char decPunctuation(int code) {
        return PUNCTUATION[code];
    }

    public static void main(String[] args) {
        System.out.println(Long.toHexString(-64L));
        System.out.println(Long.toHexString(-1L));
        System.out.println(Long.toHexString(EUROPEAN.encTranslate((byte)-64)));
        System.out.println(Long.toHexString(EUROPEAN.encTranslate((byte)-1)));
    }

    int encTranslate(byte b) {
        if (b < 0) {
            return (0xFF & b) - 192;
        }
        if (b < 32) {
            return this.encPunctuation(b);
        }
        if (b >= 48 && b <= 52) {
            return 91 + b - 48;
        }
        if (b >= 53 && b <= 57) {
            return 123 + b - 53;
        }
        return b;
    }

    abstract int encPunctuation(byte var1);

    abstract char decTranslate(byte var1);

    abstract long header(int var1);

    public static boolean encode(int keyId, String string, PropertyRecord target) {
        if (string.length() > 15) {
            return false;
        }
        if (string.equals("")) {
            ShortString.applyInRecord(target, keyId, 0L);
            return true;
        }
        EnumSet<ShortString> possible = null;
        if (string.length() < 8) {
            if (ShortString.encodeLatin1(keyId, string, target)) {
                return true;
            }
            possible = EnumSet.noneOf(ShortString.class);
        }
        byte[] data = new byte[string.length()];
        if (possible == null) {
            possible = EnumSet.allOf(ShortString.class);
            if (data.length != 10) {
                possible.remove((Object)ALPHANUM);
            }
            if (data.length > 9) {
                possible.remove((Object)EUROPEAN);
            }
            if (data.length > 12) {
                possible.removeAll(EnumSet.of(UPPER, LOWER));
            }
        }
        block13: for (int i = 0; i < data.length && !possible.isEmpty(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    data[i] = 0;
                    continue block13;
                }
                case '_': {
                    data[i] = 1;
                    possible.remove((Object)NUMERICAL);
                    continue block13;
                }
                case '.': {
                    data[i] = 2;
                    possible.remove((Object)ALPHANUM);
                    continue block13;
                }
                case '-': {
                    data[i] = 3;
                    possible.remove((Object)ALPHANUM);
                    continue block13;
                }
                case ':': {
                    data[i] = 4;
                    possible.removeAll(EnumSet.of(ALPHANUM, NUMERICAL, EUROPEAN));
                    continue block13;
                }
                case '/': {
                    data[i] = 5;
                    possible.removeAll(EnumSet.of(ALPHANUM, NUMERICAL, EUROPEAN));
                    continue block13;
                }
                case '+': {
                    data[i] = 6;
                    possible.retainAll(EnumSet.of(NUMERICAL));
                    continue block13;
                }
                case ',': {
                    data[i] = 7;
                    possible.retainAll(EnumSet.of(NUMERICAL));
                    continue block13;
                }
                case '\'': {
                    data[i] = 8;
                    possible.retainAll(EnumSet.of(NUMERICAL));
                    continue block13;
                }
                default: {
                    if (c >= 'A' && c <= 'Z') {
                        possible.remove((Object)NUMERICAL);
                        possible.remove((Object)LOWER);
                    } else if (c >= 'a' && c <= 'z') {
                        possible.remove((Object)NUMERICAL);
                        possible.remove((Object)UPPER);
                    } else if (c >= '0' && c <= '9') {
                        possible.remove((Object)UPPER);
                        possible.remove((Object)LOWER);
                    } else if (c >= '\u00c0' && c <= '\u00ff' && c != '\u00d7' && c != '\u00f7') {
                        possible.retainAll(EnumSet.of(EUROPEAN));
                    } else {
                        possible.clear();
                        break block13;
                    }
                    data[i] = (byte)c;
                }
            }
        }
        for (ShortString encoding : possible) {
            if (!encoding.doEncode(keyId, data, target)) continue;
            return true;
        }
        if (string.length() <= 6) {
            try {
                return ShortString.encodeUTF8(keyId, string.getBytes("UTF-8"), target);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("All JVMs must support UTF-8", e);
            }
        }
        return false;
    }

    private static void applyInRecord(PropertyRecord target, int keyId, long propBlock) {
    }

    public static String decode(long data) {
        ShortString table;
        if (data == 0L) {
            return "";
        }
        int header = (int)(data >>> 56);
        switch (header >>> 4) {
            case 0: {
                if ((header &= 0xF) == 0) {
                    return ShortString.decodeUTF8(data);
                }
            }
            case 1: {
                table = NUMERICAL;
                break;
            }
            case 2: {
                header &= 0xF;
            }
            case 3: {
                table = UPPER;
                break;
            }
            case 4: {
                header &= 0xF;
            }
            case 5: {
                table = LOWER;
                break;
            }
            case 6: {
                table = ALPHANUM;
                break;
            }
            case 7: {
                if (((header &= 0xF) & 8) != 0) {
                    return ShortString.decodeLatin1(data, (header & 7) + 1);
                }
                ++header;
            }
            default: {
                table = EUROPEAN;
            }
        }
        if (header > 15) {
            header = table.max;
        }
        char[] result = new char[header];
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = table.decTranslate((byte)(data & (long)table.mask));
            data >>>= table.step;
        }
        return new String(result);
    }

    private static boolean encodeLatin1(int keyId, String string, PropertyRecord target) {
        long result = 0x78 | string.length() - 1;
        result <<= (7 - string.length()) * 8;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c >= '\u0100') {
                return false;
            }
            result = result << 8 | (long)c;
        }
        ShortString.applyInRecord(target, keyId, result);
        return true;
    }

    private static boolean encodeUTF8(int keyId, byte[] bytes, PropertyRecord target) {
        if (bytes.length > 7) {
            return false;
        }
        long result = 0L;
        for (byte b : bytes) {
            result = result << 8 | (long)(0xFF & b);
        }
        ShortString.applyInRecord(target, keyId, result);
        return true;
    }

    private boolean doEncode(int keyId, byte[] data, PropertyRecord target) {
        if (data.length > this.max) {
            return false;
        }
        long result = this.header(data.length);
        result <<= (this.max - data.length) * this.step;
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                result <<= this.step;
            }
            result |= (long)this.encTranslate(data[i]);
        }
        ShortString.applyInRecord(target, keyId, result);
        return true;
    }

    private static String decodeLatin1(long data, int length) {
        char[] result = new char[length];
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (char)(data & 0xFFL);
            data >>>= 8;
        }
        return new String(result);
    }

    private static String decodeUTF8(long data) {
        byte[] result;
        byte[] temp = new byte[7];
        int size = 7;
        while (data != 0L) {
            temp[--size] = (byte)(data & 0xFFL);
            data >>>= 8;
        }
        if (size == 0) {
            result = temp;
        } else {
            result = new byte[7 - size];
            for (int i = 0; i < result.length; ++i) {
                result[i] = temp[size + i];
            }
        }
        try {
            return new String(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("All JVMs must support UTF-8", e);
        }
    }

    static {
        PUNCTUATION = new char[]{' ', '_', '.', '-', ':', '/', ' ', '.', '-', '+', ',', '\''};
    }
}

