/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.Title;

@Description(value="Settings for the Community edition of Neo4j")
public abstract class GraphDatabaseSettings {
    @Title(value="Read only database")
    @Description(value="Only allow read operations from this Neo4j instance")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting read_only = new GraphDatabaseSetting.BooleanSetting("read_only");
    @Description(value="The type of cache to use for nodes and relationships")
    @Default(value="soft")
    public static final CacheTypeSetting cache_type = new CacheTypeSetting();
    @Default(value="true")
    public static final GraphDatabaseSetting.BooleanSetting load_kernel_extensions = new GraphDatabaseSetting.BooleanSetting("load_kernel_extensions");
    @Description(value="Print out the effective Neo4j configuration after startup")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting dump_configuration = new GraphDatabaseSetting.BooleanSetting("dump_configuration");
    @Description(value="The name of the Transaction Manager service to use as defined in the TM service provider constructor, defaults to native.")
    public static final GraphDatabaseSetting.StringSetting tx_manager_impl = new GraphDatabaseSetting.StringSetting("tx_manager_impl", ".+", "Must be class name of TransactionManager implementation");
    @Description(value="Whether to allow a store upgrade in case the current version of the database starts against an older store version. Setting this to true does not guarantee successful upgrade, justthat it allows an attempt at it.")
    @Default(value="false")
    public static GraphDatabaseSetting.BooleanSetting allow_store_upgrade = new GraphDatabaseSetting.BooleanSetting("allow_store_upgrade");
    @Description(value="Determines whether any TransactionInterceptors loaded will intercept externally received transactions (e.g. in HA) before they reach the logical log and are applied to the store.")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting intercept_deserialized_transactions = new GraphDatabaseSetting.BooleanSetting("intercept_deserialized_transactions");
    @Description(value="Enable this to specify a parser other than the default one. 1.5 and 1.6 are available")
    public static final GraphDatabaseSetting.OptionsSetting cypher_parser_version = new CypherParserSetting();
    @Description(value="Whether to enable logging to a remote server or not")
    @Default(value="false")
    public static GraphDatabaseSetting remote_logging_enabled = new GraphDatabaseSetting.BooleanSetting("remote_logging_enabled");
    @Description(value="Host for remote logging using LogBack SocketAppender")
    @Default(value="127.0.0.1")
    public static final GraphDatabaseSetting.StringSetting remote_logging_host = new GraphDatabaseSetting.StringSetting("remote_logging_host", ".+", "Must be a valid hostname");
    @Description(value="Port for remote logging using LogBack SocketAppender")
    @Default(value="4560")
    public static final GraphDatabaseSetting.PortSetting remote_logging_port = new GraphDatabaseSetting.PortSetting("remote_logging_port");
    @Description(value="Controls the auto indexing feature for nodes. Setting to false shuts it down unconditionally, while true enables it for every property, subject to restrictions in the configuration.")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting node_auto_indexing = new GraphDatabaseSetting.BooleanSetting("node_auto_indexing");
    @Description(value="A list of property names (comma separated) that will be indexed by default. This applies to Nodes only.")
    public static final GraphDatabaseSetting.StringSetting node_keys_indexable = new GraphDatabaseSetting.StringSetting("node_keys_indexable", ".+", "Must be a comma-separated list of keys to be indexed");
    @Description(value="Controls the auto indexing feature for relationships. Setting to false shuts it down unconditionally, while true enables it for every property, subject to restrictions in the configuration.")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting relationship_auto_indexing = new GraphDatabaseSetting.BooleanSetting("relationship_auto_indexing");
    @Description(value=" A list of property names (comma separated) that will be indexed by default. This applies to Relationships only.")
    public static final GraphDatabaseSetting.StringSetting relationship_keys_indexable = new GraphDatabaseSetting.StringSetting("relationship_keys_indexable", ".+", "Must be a comma-separated list of keys to be indexed");
    @Description(value="Integer value that sets the maximum number of open lucene index searchers")
    @Default(value="2147483647")
    public static GraphDatabaseSetting.IntegerSetting lucene_searcher_cache_size = new GraphDatabaseSetting.IntegerSetting("lucene_searcher_cache_size", "Must be a number", 1, null);
    @Description(value="Determines whether any TransactionInterceptors loaded will intercept prepared transactions before they reach the logical log")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting intercept_committing_transactions = new GraphDatabaseSetting.BooleanSetting("intercept_committing_transactions");
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database")
    public static final GraphDatabaseSetting.StringSetting keep_logical_logs = new GraphDatabaseSetting.StringSetting("keep_logical_logs", ".+", "No value=don't store,true=store all logs,comma separated list=store logs from listed sources");
    @Description(value="Use a quick approach for rebuilding the ID generators. This give quicker recovery time, but will limit the ability to reuse the space of deleted entities.")
    @Default(value="true")
    public static final GraphDatabaseSetting.BooleanSetting rebuild_idgenerators_fast = new GraphDatabaseSetting.BooleanSetting("rebuild_idgenerators_fast");
    @Description(value="Tell Neo4j to use memory mapped buffers for accessing the native storage layer")
    public static final UseMemoryMappedBuffers use_memory_mapped_buffers = new UseMemoryMappedBuffers();
    @Description(value="The size to allocate for memory mapping the node store")
    @Default(value="20M")
    public static final GraphDatabaseSetting.StringSetting nodestore_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.nodestore.db.mapped_memory", "\\d+[kmgKMG]", "Invalid value %s, must be e.g. 20M");
    @Description(value="The size to allocate for memory mapping the property value store")
    @Default(value="90M")
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.mapped_memory", "\\d+[kmgKMG]", "Invalid value %s, must be e.g. 20M");
    @Description(value="The size to allocate for memory mapping the store for property key indexes")
    @Default(value="1M")
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_index_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.index.mapped_memory", "\\d+[kmgKMG]", "Invalid value %s, must be e.g. 20M");
    @Description(value="The size to allocate for memory mapping the store for property key strings")
    @Default(value="1M")
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_index_keys_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.index.keys.mapped_memory", "\\d+[kmgKMG]", "Invalid value %s, must be e.g. 20M");
    @Description(value="The size to allocate for memory mapping the string property store")
    @Default(value="130M")
    public static final GraphDatabaseSetting.StringSetting strings_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.strings.mapped_memory", "\\d+[kmgKMG]", "Invalid value %s, must be e.g. 20M");
    @Description(value="The size to allocate for memory mapping the array property store")
    @Default(value="130M")
    public static final GraphDatabaseSetting.StringSetting arrays_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.arrays.mapped_memory", "\\d+[kmgKMG]", "Invalid value %s, must be e.g. 20M");
    @Description(value="The size to allocate for memory mapping the relationship store")
    @Default(value="100M")
    public static final GraphDatabaseSetting.StringSetting relationshipstore_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.relationshipstore.db.mapped_memory", "\\d+[kmgKMG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="100")
    public static final GraphDatabaseSetting.IntegerSetting relationship_grab_size = new GraphDatabaseSetting.IntegerSetting("relationship_grab_size", "Must be a number");
    @Description(value="Whether to grab locks on files or not")
    @Default(value="true")
    public static final GraphDatabaseSetting.BooleanSetting grab_file_lock = new GraphDatabaseSetting.BooleanSetting("grab_file_lock");
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that a block size of 120 (the default size) will hold a 60 character long string before overflowing into a second block. Also note that each block carries an overhead of 8 bytes. This means that if the block size is 120, the size of the stored records will be 128 bytes.")
    @Default(value="120")
    public static final GraphDatabaseSetting.IntegerSetting string_block_size = new GraphDatabaseSetting.IntegerSetting("string_block_size", "Must be a number", 1, null);
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. The default block size is 120 bytes, and the overhead of each block is the same as for string blocks, i.e., 8 bytes.")
    @Default(value="120")
    public static final GraphDatabaseSetting.IntegerSetting array_block_size = new GraphDatabaseSetting.IntegerSetting("array_block_size", "Must be a number", 1, null);
    @Description(value="Mark this database as a backup slave")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting backup_slave = new GraphDatabaseSetting.BooleanSetting("backup_slave");
    @Description(value="The amount of memory to use for the node cache (when using the 'gcr' cache)")
    public static final GraphDatabaseSetting.StringSetting node_cache_size = new GraphDatabaseSetting.StringSetting("node_cache_size", "\\d+[kmgKMG]", "Must be a valid size");
    @Description(value="The amount of memory to use for the relationship cache (when using the 'gcr' cache)")
    public static final GraphDatabaseSetting.StringSetting relationship_cache_size = new GraphDatabaseSetting.StringSetting("relationship_cache_size", "\\d+[kmgKMG]", "Must be a valid size");
    @Description(value="The fraction of the heap (1%-10%) to use for the base array in the node cache (when using the 'gcr' cache)")
    @Default(value="1.0")
    public static final GraphDatabaseSetting.FloatSetting node_cache_array_fraction = new GraphDatabaseSetting.FloatSetting("node_cache_array_fraction", "Must be a valid fraction", Float.valueOf(1.0f), Float.valueOf(10.0f));
    @Description(value="The fraction of the heap (1%-10%) to use for the base array in the relationship cache (when using the 'gcr' cache)")
    @Default(value="1.0")
    public static final GraphDatabaseSetting.FloatSetting relationship_cache_array_fraction = new GraphDatabaseSetting.FloatSetting("relationship_cache_array_fraction", "Must be a valid fraction", Float.valueOf(1.0f), Float.valueOf(10.0f));
    @Description(value="The minimal time that must pass in between logging statistics from the cache (when using the 'gcr' cache)")
    @Default(value="60s")
    public static final GraphDatabaseSetting.StringSetting gcr_cache_min_log_interval = new GraphDatabaseSetting.StringSetting("gcr_cache_min_log_interval", "\\d+(ms|s|m)", "Must be a valid interval");
    @Default(value="false")
    public static GraphDatabaseSetting.BooleanSetting execution_guard_enabled = new GraphDatabaseSetting.BooleanSetting("execution_guard_enabled");
    @Description(value="Amount of time in ms the GC monitor thread will wait before taking another measurement.")
    @Default(value="100ms")
    public static GraphDatabaseSetting.StringSetting gc_monitor_wait_time = new GraphDatabaseSetting.StringSetting("gc_monitor_wait_time", "\\d+(ms|s|m)", "Must be a valid duration");
    @Description(value="The amount of time in ms the monitor thread has to be blocked before logging a message it was blocked.")
    @Default(value="200ms")
    public static GraphDatabaseSetting.StringSetting gc_monitor_threshold = new GraphDatabaseSetting.StringSetting("gc_monitor_threshold", "\\d+(ms|s|m)", "Must be a valid duration");

    public static class UseMemoryMappedBuffers
    extends GraphDatabaseSetting.BooleanSetting
    implements GraphDatabaseSetting.DefaultValue {
        public UseMemoryMappedBuffers() {
            super("use_memory_mapped_buffers");
        }

        @Override
        public String getDefaultValue() {
            if (UseMemoryMappedBuffers.osIsWindows()) {
                return "false";
            }
            return "true";
        }
    }

    public static class CypherParserSetting
    extends GraphDatabaseSetting.OptionsSetting {
        @Description(value="Cypher v1.5 syntax")
        public static final String v1_5 = "1.5";
        @Description(value="Cypher v1.6 syntax")
        public static final String v1_6 = "1.6";
        @Description(value="Cypher v1.7 syntax")
        public static final String v1_7 = "1.7";

        public CypherParserSetting() {
            super("cypher_parser_version", v1_5, v1_6, v1_7);
        }
    }

    public static class CacheTypeSetting
    extends GraphDatabaseSetting.OptionsSetting {
        @Description(value="Use weak reference cache")
        public static final String weak = "weak";
        @Description(value="Provides optimal utilization of the available memory. Suitable for high performance traversal. \nMay run into GC issues under high load if the frequently accessed parts of the graph does not fit in the cache.")
        public static final String soft = "soft";
        @Description(value="Don't use caching")
        public static final String none = "none";
        @Description(value="Use strong references")
        public static final String strong = "strong";
        @Description(value="GC resistant cache. Gets assigned a configurable amount of space in the JVM heap \nand will evict objects whenever it grows bigger than that, instead of relying on GC for eviction. \nIt has got the fastest insert/lookup times and should be optimal for most use cases. \nThis is the default cache setting.")
        public static final String gcr = "gcr";

        public CacheTypeSetting() {
            super("cache_type", CacheTypeSetting.availableCaches());
        }

        private static String[] availableCaches() {
            try {
                GraphDatabaseSettings.class.getClassLoader().loadClass("org.neo4j.kernel.impl.cache.GCResistantCacheProvider");
                return new String[]{gcr, soft, weak, strong, none};
            }
            catch (ClassNotFoundException e) {
                return new String[]{soft, weak, strong, none};
            }
        }
    }
}

