/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.NullLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.BufferedFileChannel;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class XaLogicalLog
implements LogExtractor.LogLoader {
    private final Logger log;
    private static final char CLEAN = 'C';
    private static final char LOG1 = '1';
    private static final char LOG2 = '2';
    private FileChannel fileChannel = null;
    private final ByteBuffer sharedBuffer;
    private LogBuffer writeBuffer = null;
    private long previousLogLastCommittedTx = -1L;
    private long logVersion = 0L;
    private final ArrayMap<Integer, LogEntry.Start> xidIdentMap = new ArrayMap(4, false, true);
    private final Map<Integer, XaTransaction> recoveredTxMap = new HashMap<Integer, XaTransaction>();
    private int nextIdentifier = 1;
    private boolean scanIsComplete = false;
    private boolean nonCleanShutdown = false;
    private String fileName = null;
    private final XaResourceManager xaRm;
    private final XaCommandFactory cf;
    private final XaTransactionFactory xaTf;
    private char currentLog = (char)67;
    private boolean keepLogs = false;
    private boolean autoRotate = true;
    private long rotateAtSize = 0x1900000L;
    private final LogBufferFactory logBufferFactory;
    private boolean doingRecovery;
    private long lastRecoveredTx = -1L;
    private long recoveredTxCount;
    private final StringLogger msgLog;
    private final LogExtractor.LogPositionCache positionCache = new LogExtractor.LogPositionCache();
    private final FileSystemAbstraction fileSystem;
    private final ArrayMap<Thread, Integer> txIdentMap = new ArrayMap(5, true, true);
    public static final int MASTER_ID_REPRESENTING_NO_MASTER = -1;

    public XaLogicalLog(String fileName, XaResourceManager xaRm, XaCommandFactory cf, XaTransactionFactory xaTf, LogBufferFactory logBufferFactory, FileSystemAbstraction fileSystem, StringLogger stringLogger) {
        this.fileName = fileName;
        this.xaRm = xaRm;
        this.cf = cf;
        this.xaTf = xaTf;
        this.logBufferFactory = logBufferFactory;
        this.fileSystem = fileSystem;
        this.log = Logger.getLogger(this.getClass().getName() + File.separator + fileName);
        this.sharedBuffer = ByteBuffer.allocateDirect(713);
        this.msgLog = stringLogger;
        this.keepLogs = this.hasPreviousLogs();
    }

    synchronized void open() throws IOException {
        String activeFileName = this.fileName + ".active";
        if (!this.fileSystem.fileExists(activeFileName)) {
            if (this.fileSystem.fileExists(this.fileName)) {
                this.open(this.fileName);
            } else {
                this.open(this.getLog1FileName());
                this.setActiveLog('1');
            }
        } else {
            FileChannel fc = this.fileSystem.open(activeFileName, "rw");
            byte[] bytes = new byte[256];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            int read = fc.read(buf);
            fc.close();
            if (read != 4) {
                throw new IllegalStateException("Read " + read + " bytes from " + activeFileName + " but expected 4");
            }
            buf.flip();
            char c = buf.asCharBuffer().get();
            if (c == 'C') {
                String newLog = this.getLog1FileName();
                this.renameIfExists(newLog);
                this.renameIfExists(this.getLog2FileName());
                this.open(newLog);
                this.setActiveLog('1');
            } else if (c == '1') {
                String newLog = this.getLog1FileName();
                if (!this.fileSystem.fileExists(newLog)) {
                    throw new IllegalStateException("Active marked as 1 but no " + newLog + " exist");
                }
                if (this.fileSystem.fileExists(this.getLog2FileName())) {
                    this.fixDualLogFiles(this.getLog1FileName(), this.getLog2FileName());
                }
                this.currentLog = (char)49;
                this.open(newLog);
            } else if (c == '2') {
                String newLog = this.getLog2FileName();
                if (!this.fileSystem.fileExists(newLog)) {
                    throw new IllegalStateException("Active marked as 2 but no " + newLog + " exist");
                }
                if (this.fileSystem.fileExists(this.getLog1FileName())) {
                    this.fixDualLogFiles(this.getLog2FileName(), this.getLog1FileName());
                }
                this.currentLog = (char)50;
                this.open(newLog);
            } else {
                throw new IllegalStateException("Unknown active log: " + c);
            }
        }
        this.instantiateCorrectWriteBuffer();
    }

    private void renameIfExists(String fileName) throws IOException {
        if (this.fileSystem.fileExists(fileName)) {
            this.renameLogFileToRightVersion(fileName, this.fileSystem.getFileSize(fileName));
            this.xaTf.getAndSetNewVersion();
        }
    }

    private void instantiateCorrectWriteBuffer() throws IOException {
        this.writeBuffer = this.instantiateCorrectWriteBuffer(this.fileChannel);
    }

    private LogBuffer instantiateCorrectWriteBuffer(FileChannel channel) throws IOException {
        return this.logBufferFactory.create(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(String fileToOpen) throws IOException {
        this.fileChannel = this.fileSystem.open(fileToOpen, "rw");
        if (this.fileChannel.size() != 0L) {
            this.nonCleanShutdown = true;
            this.doingRecovery = true;
            try {
                this.doInternalRecovery(fileToOpen);
            }
            finally {
                this.doingRecovery = false;
            }
        } else {
            this.logVersion = this.xaTf.getCurrentVersion();
            long lastTxId = this.xaTf.getLastCommittedTx();
            LogIoUtils.writeLogHeader(this.sharedBuffer, this.logVersion, lastTxId);
            this.previousLogLastCommittedTx = lastTxId;
            this.positionCache.putHeader(this.logVersion, this.previousLogLastCommittedTx);
            this.fileChannel.write(this.sharedBuffer);
            this.scanIsComplete = true;
            this.msgLog.logMessage("Opened [" + fileToOpen + "] clean empty log, version=" + this.logVersion + ", lastTxId=" + lastTxId, true);
        }
    }

    public boolean scanIsComplete() {
        return this.scanIsComplete;
    }

    private int getNextIdentifier() {
        ++this.nextIdentifier;
        if (this.nextIdentifier < 0) {
            this.nextIdentifier = 1;
        }
        return this.nextIdentifier;
    }

    public synchronized int start(Xid xid, int masterId, int myId) throws XAException {
        int xidIdent = this.getNextIdentifier();
        long timeWritten = System.currentTimeMillis();
        LogEntry.Start start = new LogEntry.Start(xid, xidIdent, masterId, myId, -1L, timeWritten);
        this.xidIdentMap.put(xidIdent, start);
        return xidIdent;
    }

    public synchronized void writeStartEntry(int identifier) throws XAException {
        try {
            long position = this.writeBuffer.getFileChannelPosition();
            LogEntry.Start start = this.xidIdentMap.get(identifier);
            start.setStartPosition(position);
            LogIoUtils.writeStart(this.writeBuffer, identifier, start.getXid(), start.getMasterId(), start.getLocalId(), start.getTimeWritten());
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log couldn't write transaction start entry: " + e), e);
        }
    }

    synchronized LogEntry.Start getStartEntry(int identifier) {
        LogEntry.Start start = this.xidIdentMap.get(identifier);
        if (start == null) {
            throw new IllegalArgumentException("Start entry for " + identifier + " not found");
        }
        return start;
    }

    public synchronized void prepare(int identifier) throws XAException {
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        try {
            LogIoUtils.writePrepare(this.writeBuffer, identifier, System.currentTimeMillis());
            this.writeBuffer.writeOut();
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark prepare [" + identifier + "] "), e);
        }
    }

    public synchronized void commitOnePhase(int identifier, long txId, ForceMode forceMode) throws XAException {
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        assert (txId != -1L);
        try {
            this.cacheTxStartPosition(txId, startEntry);
            LogIoUtils.writeCommit(false, this.writeBuffer, identifier, txId, System.currentTimeMillis());
            forceMode.force(this.writeBuffer);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark 1P-commit [" + identifier + "] "), e);
        }
    }

    private synchronized void cacheTxStartPosition(long txId, LogEntry.Start startEntry) {
        this.cacheTxStartPosition(txId, startEntry, this.logVersion);
    }

    private synchronized LogExtractor.TxPosition cacheTxStartPosition(long txId, LogEntry.Start startEntry, long logVersion) {
        if (startEntry.getStartPosition() == -1L) {
            throw new RuntimeException("StartEntry.position is " + startEntry.getStartPosition());
        }
        LogExtractor.TxPosition result = new LogExtractor.TxPosition(logVersion, startEntry.getMasterId(), startEntry.getIdentifier(), startEntry.getStartPosition(), startEntry.getChecksum());
        this.positionCache.putStartPosition(txId, result);
        return result;
    }

    public synchronized void done(int identifier) throws XAException {
        assert (this.xidIdentMap.get(identifier) != null);
        try {
            LogIoUtils.writeDone(this.writeBuffer, identifier);
            this.xidIdentMap.remove(identifier);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark as done [" + identifier + "] "), e);
        }
    }

    synchronized void doneInternal(int identifier) throws IOException {
        if (this.writeBuffer != null) {
            LogIoUtils.writeDone(this.writeBuffer, identifier);
        } else {
            this.sharedBuffer.clear();
            LogIoUtils.writeDone(this.sharedBuffer, identifier);
            this.sharedBuffer.flip();
            this.fileChannel.write(this.sharedBuffer);
        }
        this.xidIdentMap.remove(identifier);
    }

    public synchronized void commitTwoPhase(int identifier, long txId, ForceMode forceMode) throws XAException {
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        assert (txId != -1L);
        try {
            this.cacheTxStartPosition(txId, startEntry);
            LogIoUtils.writeCommit(true, this.writeBuffer, identifier, txId, System.currentTimeMillis());
            forceMode.force(this.writeBuffer);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark 2PC [" + identifier + "] "), e);
        }
    }

    public synchronized void writeCommand(XaCommand command, int identifier) throws IOException {
        this.checkLogRotation();
        assert (this.xidIdentMap.get(identifier) != null);
        LogIoUtils.writeCommand(this.writeBuffer, identifier, command);
    }

    private void applyEntry(LogEntry entry) throws IOException {
        if (entry instanceof LogEntry.Start) {
            this.applyStartEntry((LogEntry.Start)entry);
        } else if (entry instanceof LogEntry.Prepare) {
            this.applyPrepareEntry((LogEntry.Prepare)entry);
        } else if (entry instanceof LogEntry.Command) {
            this.applyCommandEntry((LogEntry.Command)entry);
        } else if (entry instanceof LogEntry.OnePhaseCommit) {
            this.applyOnePhaseCommitEntry((LogEntry.OnePhaseCommit)entry);
        } else if (entry instanceof LogEntry.TwoPhaseCommit) {
            this.applyTwoPhaseCommitEntry((LogEntry.TwoPhaseCommit)entry);
        } else if (entry instanceof LogEntry.Done) {
            this.applyDoneEntry((LogEntry.Done)entry);
        } else {
            throw new RuntimeException("Unrecognized log entry " + entry);
        }
    }

    private void applyStartEntry(LogEntry.Start entry) throws IOException {
        int identifier = entry.getIdentifier();
        if (identifier >= this.nextIdentifier) {
            this.nextIdentifier = identifier + 1;
        }
        Xid xid = entry.getXid();
        this.xidIdentMap.put(identifier, entry);
        XaTransaction xaTx = this.xaTf.create(identifier);
        xaTx.setRecovered();
        this.recoveredTxMap.put(identifier, xaTx);
        this.xaRm.injectStart(xid, xaTx);
    }

    private void applyPrepareEntry(LogEntry.Prepare prepareEntry) throws IOException {
        int identifier = prepareEntry.getIdentifier();
        LogEntry.Start entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = entry.getXid();
        if (this.xaRm.injectPrepare(xid)) {
            this.xidIdentMap.remove(identifier);
            this.recoveredTxMap.remove(identifier);
        }
    }

    private void applyOnePhaseCommitEntry(LogEntry.OnePhaseCommit commit) throws IOException {
        int identifier = commit.getIdentifier();
        long txId = commit.getTxId();
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        if (startEntry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = startEntry.getXid();
        try {
            XaTransaction xaTx = this.xaRm.getXaTransaction(xid);
            xaTx.setCommitTxId(txId);
            this.cacheTxStartPosition(txId, startEntry);
            this.xaRm.injectOnePhaseCommit(xid);
            this.registerRecoveredTransaction(txId);
        }
        catch (XAException e) {
            throw new IOException(e);
        }
    }

    private void registerRecoveredTransaction(long txId) {
        if (this.doingRecovery) {
            this.lastRecoveredTx = txId;
            ++this.recoveredTxCount;
        }
    }

    private void logRecoveryMessage(String string) {
        if (this.doingRecovery) {
            this.msgLog.logMessage(string, true);
        }
    }

    private void applyDoneEntry(LogEntry.Done done) throws IOException {
        int identifier = done.getIdentifier();
        LogEntry.Start entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = entry.getXid();
        this.xaRm.pruneXid(xid);
        this.xidIdentMap.remove(identifier);
        this.recoveredTxMap.remove(identifier);
    }

    private void applyTwoPhaseCommitEntry(LogEntry.TwoPhaseCommit commit) throws IOException {
        int identifier = commit.getIdentifier();
        long txId = commit.getTxId();
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        if (startEntry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = startEntry.getXid();
        if (xid == null) {
            throw new IOException("Xid null for identifier " + identifier);
        }
        try {
            XaTransaction xaTx = this.xaRm.getXaTransaction(xid);
            xaTx.setCommitTxId(txId);
            this.cacheTxStartPosition(txId, startEntry);
            this.xaRm.injectTwoPhaseCommit(xid);
            this.registerRecoveredTransaction(txId);
        }
        catch (XAException e) {
            throw new IOException(e);
        }
    }

    private void applyCommandEntry(LogEntry.Command entry) throws IOException {
        int identifier = entry.getIdentifier();
        XaCommand command = entry.getXaCommand();
        if (command == null) {
            throw new IOException("Null command for identifier " + identifier);
        }
        command.setRecovered();
        XaTransaction xaTx = this.recoveredTxMap.get(identifier);
        xaTx.injectCommand(command);
    }

    private void checkLogRotation() throws IOException {
        long firstStartEntry;
        long currentPos;
        if (this.autoRotate && this.writeBuffer.getFileChannelPosition() >= this.rotateAtSize && (currentPos = this.writeBuffer.getFileChannelPosition()) - (firstStartEntry = this.getFirstStartEntry(currentPos)) < this.rotateAtSize / 2L) {
            this.rotate();
        }
    }

    private void fixDualLogFiles(String activeLog, String oldLog) throws IOException {
        FileChannel activeLogChannel = this.fileSystem.open(activeLog, "r");
        long[] activeLogHeader = LogIoUtils.readLogHeader(ByteBuffer.allocate(16), activeLogChannel, false);
        activeLogChannel.close();
        FileChannel oldLogChannel = this.fileSystem.open(oldLog, "r");
        long[] oldLogHeader = LogIoUtils.readLogHeader(ByteBuffer.allocate(16), oldLogChannel, false);
        oldLogChannel.close();
        if (oldLogHeader == null) {
            if (!this.fileSystem.deleteFile(oldLog)) {
                throw new IOException("Unable to delete " + oldLog);
            }
        } else if (activeLogHeader == null || activeLogHeader[0] > oldLogHeader[0]) {
            String newName = this.getFileName(oldLogHeader[0]);
            if (!this.fileSystem.renameFile(oldLog, newName)) {
                throw new IOException("Unable to rename " + oldLog + " to " + newName);
            }
        } else {
            assert (activeLogHeader[0] < oldLogHeader[0]);
            if (!this.fileSystem.deleteFile(oldLog)) {
                throw new IOException("Unable to delete " + oldLog);
            }
        }
    }

    private void renameLogFileToRightVersion(String logFileName, long endPosition) throws IOException {
        if (!this.fileSystem.fileExists(logFileName)) {
            throw new IOException("Logical log[" + logFileName + "] not found");
        }
        FileChannel channel = this.fileSystem.open(logFileName, "rw");
        long[] header = LogIoUtils.readLogHeader(ByteBuffer.allocate(16), channel, false);
        try {
            FileUtils.truncateFile(channel, endPosition);
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "Failed to truncate log at correct size", e);
        }
        channel.close();
        String newName = header == null ? this.getFileName(-1L) + "_empty_header_log_" + System.currentTimeMillis() : this.getFileName(header[0]);
        if (!this.fileSystem.renameFile(logFileName, newName)) {
            throw new IOException("Failed to rename log to: " + newName);
        }
    }

    private void deleteLogFile(String logFileName) throws IOException {
        if (!this.fileSystem.fileExists(logFileName)) {
            throw new IOException("Logical log[" + logFileName + "] not found");
        }
        if (!this.fileSystem.deleteFile(logFileName)) {
            this.log.warning("Unable to delete clean logical log[" + logFileName + "]");
        }
    }

    private void releaseCurrentLogFile() throws IOException {
        if (this.writeBuffer != null) {
            this.writeBuffer.force();
        }
        this.fileChannel.close();
        this.fileChannel = null;
    }

    public synchronized void close() throws IOException {
        if (this.fileChannel == null || !this.fileChannel.isOpen()) {
            this.log.fine("Logical log: " + this.fileName + " already closed");
            return;
        }
        long endPosition = this.writeBuffer.getFileChannelPosition();
        if (this.xidIdentMap.size() > 0) {
            this.log.info("Close invoked with " + this.xidIdentMap.size() + " running transaction(s). ");
            this.writeBuffer.force();
            this.fileChannel.close();
            this.log.info("Dirty log: " + this.fileName + "." + this.currentLog + " now closed. Recovery will be started automatically next " + "time it is opened.");
            return;
        }
        this.releaseCurrentLogFile();
        char logWas = this.currentLog;
        if (this.currentLog != 'C') {
            this.setActiveLog('C');
        }
        if (!this.keepLogs) {
            if (logWas == 'C') {
                this.deleteLogFile(this.fileName);
            } else {
                this.deleteLogFile(this.fileName + "." + logWas);
            }
        } else {
            this.renameLogFileToRightVersion(this.fileName + "." + logWas, endPosition);
            this.xaTf.getAndSetNewVersion();
        }
        this.msgLog.logMessage("Closed log " + this.fileName, true);
    }

    static long[] readAndAssertLogHeader(ByteBuffer localBuffer, ReadableByteChannel channel, long expectedVersion) throws IOException {
        long[] header = LogIoUtils.readLogHeader(localBuffer, channel, true);
        if (header[0] != expectedVersion) {
            throw new IOException("Wrong version in log. Expected " + expectedVersion + ", but got " + header[0]);
        }
        return header;
    }

    StringLogger getStringLogger() {
        return this.msgLog;
    }

    private void doInternalRecovery(String logFileName) throws IOException {
        LogEntry entry;
        long lastCommittedTx;
        this.log.info("Non clean shutdown detected on log [" + logFileName + "]. Recovery started ...");
        this.msgLog.logMessage("Non clean shutdown detected on log [" + logFileName + "]. Recovery started ...", true);
        long[] header = this.readLogHeader(this.fileChannel, "Tried to do recovery on log with illegal format version");
        if (header == null) {
            this.log.info("Unable to read header information, no records in logical log.");
            this.msgLog.logMessage("No log version found for " + logFileName, true);
            this.fileChannel.close();
            boolean success = this.fileSystem.renameFile(logFileName, logFileName + "_unknown_timestamp_" + System.currentTimeMillis() + ".log");
            assert (success);
            this.fileChannel.close();
            this.fileChannel = this.fileSystem.open(logFileName, "rw");
            return;
        }
        this.logVersion = header[0];
        this.previousLogLastCommittedTx = lastCommittedTx = header[1];
        this.positionCache.putHeader(this.logVersion, this.previousLogLastCommittedTx);
        this.log.fine("Logical log version: " + this.logVersion + " with committed tx[" + lastCommittedTx + "]");
        this.msgLog.logMessage("[" + logFileName + "] logVersion=" + this.logVersion + " with committed tx=" + lastCommittedTx, true);
        long logEntriesFound = 0L;
        long lastEntryPos = this.fileChannel.position();
        this.fileChannel = new BufferedFileChannel(this.fileChannel);
        while ((entry = this.readEntry()) != null) {
            this.applyEntry(entry);
            ++logEntriesFound;
            lastEntryPos = this.fileChannel.position();
        }
        this.fileChannel = ((BufferedFileChannel)this.fileChannel).getSource();
        this.fileChannel.position(lastEntryPos);
        this.msgLog.logMessage("[" + logFileName + "] entries found=" + logEntriesFound + " lastEntryPos=" + lastEntryPos, true);
        this.sharedBuffer.clear();
        while (this.sharedBuffer.hasRemaining()) {
            this.sharedBuffer.put((byte)0);
        }
        this.sharedBuffer.flip();
        long endPosition = this.fileChannel.size();
        do {
            long bytesLeft;
            if ((bytesLeft = this.fileChannel.size() - this.fileChannel.position()) < (long)this.sharedBuffer.capacity()) {
                this.sharedBuffer.limit((int)bytesLeft);
            }
            this.fileChannel.write(this.sharedBuffer);
            this.sharedBuffer.flip();
        } while (this.fileChannel.position() < endPosition);
        this.fileChannel.position(lastEntryPos);
        this.scanIsComplete = true;
        String recoveryCompletedMessage = "Internal recovery completed, scanned " + logEntriesFound + " log entries. Recovered " + this.recoveredTxCount + " transactions. Last tx recovered: " + this.lastRecoveredTx;
        this.log.fine(recoveryCompletedMessage);
        this.msgLog.logMessage(recoveryCompletedMessage);
        this.xaRm.checkXids();
        if (this.xidIdentMap.size() == 0) {
            this.log.fine("Recovery completed.");
            this.msgLog.logMessage("Recovery on log [" + logFileName + "] completed.");
        } else {
            this.log.fine("[" + logFileName + "] Found " + this.xidIdentMap.size() + " prepared 2PC transactions.");
            this.msgLog.logMessage("Recovery on log [" + logFileName + "] completed with " + this.xidIdentMap + " prepared transactions found.");
            for (LogEntry.Start startEntry : this.xidIdentMap.values()) {
                this.log.fine("[" + logFileName + "] 2PC xid[" + startEntry.getXid() + "]");
            }
        }
        this.recoveredTxMap.clear();
    }

    void reset() {
        this.xidIdentMap.clear();
        this.recoveredTxMap.clear();
    }

    private LogEntry readEntry() throws IOException {
        long position = this.fileChannel.position();
        LogEntry entry = LogIoUtils.readEntry(this.sharedBuffer, this.fileChannel, this.cf);
        if (entry instanceof LogEntry.Start) {
            ((LogEntry.Start)entry).setStartPosition(position);
        }
        return entry;
    }

    void registerTxIdentifier(int identifier) {
        this.txIdentMap.put(Thread.currentThread(), identifier);
    }

    void unregisterTxIdentifier() {
        this.txIdentMap.remove(Thread.currentThread());
    }

    public int getCurrentTxIdentifier() {
        Integer intValue = this.txIdentMap.get(Thread.currentThread());
        if (intValue != null) {
            return intValue;
        }
        return -1;
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.getLogicalLog(version, 0L);
    }

    public ReadableByteChannel getLogicalLog(long version, long position) throws IOException {
        String name = this.getFileName(version);
        if (!this.fileSystem.fileExists(name)) {
            throw new NoSuchLogVersionException(version);
        }
        FileChannel channel = this.fileSystem.open(name, "r");
        channel.position(position);
        return new BufferedFileChannel(channel);
    }

    private void extractPreparedTransactionFromLog(int identifier, FileChannel logChannel, LogBuffer targetBuffer) throws IOException {
        LogEntry entry;
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        logChannel.position(startEntry.getStartPosition());
        boolean found = false;
        while ((entry = LogIoUtils.readEntry(this.sharedBuffer, logChannel, this.cf)) != null) {
            if (entry.getIdentifier() != identifier) continue;
            if (entry instanceof LogEntry.Prepare) break;
            if (entry instanceof LogEntry.Start || entry instanceof LogEntry.Command) {
                LogIoUtils.writeLogEntry(entry, targetBuffer);
                found = true;
                continue;
            }
            throw new RuntimeException("Expected start or command entry but found: " + entry);
        }
        if (!found) {
            throw new IOException("Transaction for internal identifier[" + identifier + "] not found in current log");
        }
    }

    public synchronized ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        FileChannel logChannel = (FileChannel)this.getLogicalLogOrMyselfPrepared(this.logVersion, 0L);
        InMemoryLogBuffer localBuffer = new InMemoryLogBuffer();
        this.extractPreparedTransactionFromLog(identifier, logChannel, localBuffer);
        logChannel.close();
        return localBuffer;
    }

    public synchronized void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        FileChannel logChannel = (FileChannel)this.getLogicalLogOrMyselfPrepared(this.logVersion, 0L);
        this.extractPreparedTransactionFromLog(identifier, logChannel, targetBuffer);
        logChannel.close();
    }

    public LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
        return new LogExtractor(this.positionCache, this, this.cf, startTxId, endTxIdHint);
    }

    public synchronized Pair<Integer, Long> getMasterForCommittedTransaction(long txId) throws IOException {
        if (txId == 1L) {
            return Pair.of(-1, 0L);
        }
        LogExtractor.TxPosition cache = this.positionCache.getStartPosition(txId);
        if (cache != null) {
            return Pair.of(cache.masterId, cache.checksum);
        }
        LogExtractor extractor = this.getLogExtractor(txId, txId);
        try {
            if (extractor.extractNext(NullLogBuffer.INSTANCE) != -1L) {
                Pair<Integer, Long> pair = Pair.of(extractor.getLastStartEntry().getMasterId(), extractor.getLastTxChecksum());
                return pair;
            }
            throw new RuntimeException("Unable to find commit entry for txId[" + txId + "]");
        }
        finally {
            extractor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadableByteChannel getLogicalLogOrMyselfCommitted(long version, long position) throws IOException {
        XaLogicalLog xaLogicalLog = this;
        synchronized (xaLogicalLog) {
            if (version == this.logVersion) {
                String currentLogName = this.getCurrentLogFileName();
                FileChannel channel = this.fileSystem.open(currentLogName, "r");
                channel.position(position);
                return new BufferedFileChannel(channel);
            }
        }
        if (version < this.logVersion) {
            return this.getLogicalLog(version, position);
        }
        throw new RuntimeException("Version[" + version + "] is higher then current log version[" + this.logVersion + "]");
    }

    private ReadableByteChannel getLogicalLogOrMyselfPrepared(long version, long position) throws IOException {
        if (version < this.logVersion) {
            return this.getLogicalLog(version, position);
        }
        if (version == this.logVersion) {
            String currentLogName = this.getCurrentLogFileName();
            FileChannel channel = this.fileSystem.open(currentLogName, "r");
            channel = new BufferedFileChannel(channel);
            this.writeBuffer.writeOut();
            channel.position(position);
            return channel;
        }
        throw new RuntimeException("Version[" + version + "] is higher then current log version[" + this.logVersion + "]");
    }

    private String getCurrentLogFileName() {
        return this.currentLog == '1' ? this.getLog1FileName() : this.getLog2FileName();
    }

    public long getLogicalLogLength(long version) {
        return this.fileSystem.getFileSize(this.getFileName(version));
    }

    public boolean hasLogicalLog(long version) {
        return this.fileSystem.fileExists(this.getFileName(version));
    }

    public boolean deleteLogicalLog(long version) {
        String file = this.getFileName(version);
        return this.fileSystem.fileExists(file) ? this.fileSystem.deleteFile(file) : false;
    }

    protected LogDeserializer getLogDeserializer(ReadableByteChannel byteChannel) {
        return new LogDeserializer(byteChannel);
    }

    private long[] readLogHeader(ReadableByteChannel source, String message) throws IOException {
        try {
            return LogIoUtils.readLogHeader(this.sharedBuffer, source, true);
        }
        catch (IllegalLogFormatException e) {
            this.msgLog.logMessage(message, e);
            throw e;
        }
    }

    public synchronized void applyTransactionWithoutTxId(ReadableByteChannel byteChannel, long nextTxId, ForceMode forceMode) throws IOException {
        if (nextTxId != this.xaTf.getLastCommittedTx() + 1L) {
            throw new IllegalStateException("Tried to apply tx " + nextTxId + " but expected transaction " + (this.xaTf.getCurrentVersion() + 1L));
        }
        this.logRecoveryMessage("applyTxWithoutTxId log version: " + this.logVersion + ", committing tx=" + nextTxId + ") @ pos " + this.writeBuffer.getFileChannelPosition());
        long logEntriesFound = 0L;
        this.scanIsComplete = false;
        LogDeserializer logApplier = this.getLogDeserializer(byteChannel);
        int xidIdent = this.getNextIdentifier();
        long startEntryPosition = this.writeBuffer.getFileChannelPosition();
        while (logApplier.readAndWriteAndApplyEntry(xidIdent)) {
            ++logEntriesFound;
        }
        byteChannel.close();
        LogEntry.Start startEntry = logApplier.getStartEntry();
        if (startEntry == null) {
            throw new IOException("Unable to find start entry");
        }
        startEntry.setStartPosition(startEntryPosition);
        LogEntry.OnePhaseCommit commit = new LogEntry.OnePhaseCommit(xidIdent, nextTxId, System.currentTimeMillis());
        LogIoUtils.writeLogEntry(commit, this.writeBuffer);
        forceMode.force(this.writeBuffer);
        Xid xid = startEntry.getXid();
        try {
            XaTransaction xaTx = this.xaRm.getXaTransaction(xid);
            xaTx.setCommitTxId(nextTxId);
            this.cacheTxStartPosition(nextTxId, startEntry);
            this.xaRm.commit(xid, true);
            LogEntry.Done doneEntry = new LogEntry.Done(startEntry.getIdentifier());
            LogIoUtils.writeLogEntry(doneEntry, this.writeBuffer);
            this.xidIdentMap.remove(startEntry.getIdentifier());
            this.recoveredTxMap.remove(startEntry.getIdentifier());
        }
        catch (XAException e) {
            throw new IOException(e);
        }
        this.scanIsComplete = true;
        this.logRecoveryMessage("Applied external tx and generated tx id=" + nextTxId);
        this.checkLogRotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyTransaction(ReadableByteChannel byteChannel) throws IOException {
        long logEntriesFound = 0L;
        this.scanIsComplete = false;
        LogDeserializer logApplier = this.getLogDeserializer(byteChannel);
        int xidIdent = this.getNextIdentifier();
        long startEntryPosition = this.writeBuffer.getFileChannelPosition();
        boolean successfullyApplied = false;
        try {
            while (logApplier.readAndWriteAndApplyEntry(xidIdent)) {
                ++logEntriesFound;
            }
            successfullyApplied = true;
        }
        finally {
            if (!successfullyApplied && logApplier.getStartEntry() != null && this.xidIdentMap.get(xidIdent) != null) {
                try {
                    this.xaRm.forget(logApplier.getStartEntry().getXid());
                }
                catch (XAException e) {
                    throw new IOException(e);
                }
                finally {
                    this.xidIdentMap.remove(xidIdent);
                }
            }
        }
        byteChannel.close();
        this.scanIsComplete = true;
        LogEntry.Start startEntry = logApplier.getStartEntry();
        if (startEntry == null) {
            throw new IOException("Unable to find start entry");
        }
        startEntry.setStartPosition(startEntryPosition);
        this.cacheTxStartPosition(logApplier.getCommitEntry().getTxId(), startEntry);
        this.checkLogRotation();
    }

    private String getLog1FileName() {
        return this.fileName + ".1";
    }

    private String getLog2FileName() {
        return this.fileName + ".2";
    }

    public synchronized long rotate() throws IOException {
        this.xaTf.flushAll();
        String newLogFile = this.getLog2FileName();
        String currentLogFile = this.getLog1FileName();
        char newActiveLog = '2';
        long currentVersion = this.xaTf.getCurrentVersion();
        String oldCopy = this.getFileName(currentVersion);
        if (this.currentLog == 'C' || this.currentLog == '2') {
            newActiveLog = '1';
            newLogFile = this.getLog1FileName();
            currentLogFile = this.getLog2FileName();
        } else assert (this.currentLog == '1');
        this.assertFileDoesntExist(newLogFile, "New log file");
        this.assertFileDoesntExist(oldCopy, "Copy log file");
        this.msgLog.logMessage("Rotating [" + currentLogFile + "] @ version=" + currentVersion + " to " + newLogFile + " from position " + this.writeBuffer.getFileChannelPosition(), true);
        long endPosition = this.writeBuffer.getFileChannelPosition();
        this.writeBuffer.force();
        FileChannel newLog = this.fileSystem.open(newLogFile, "rw");
        long lastTx = this.xaTf.getLastCommittedTx();
        LogIoUtils.writeLogHeader(this.sharedBuffer, currentVersion + 1L, lastTx);
        this.previousLogLastCommittedTx = lastTx;
        if (newLog.write(this.sharedBuffer) != 16) {
            throw new IOException("Unable to write log version to new");
        }
        long pos = this.fileChannel.position();
        this.fileChannel.position(0L);
        XaLogicalLog.readAndAssertLogHeader(this.sharedBuffer, this.fileChannel, currentVersion);
        this.fileChannel.position(pos);
        if (this.xidIdentMap.size() > 0) {
            long firstEntryPosition = this.getFirstStartEntry(endPosition);
            this.fileChannel.position(firstEntryPosition);
            this.msgLog.logMessage("Rotate log first start entry @ pos=" + firstEntryPosition + " out of " + this.xidIdentMap);
        }
        LogBuffer newLogBuffer = this.instantiateCorrectWriteBuffer(newLog);
        this.copyPartiallyWrittenTransactionsToTheNewLog(newLogBuffer);
        newLogBuffer.force();
        newLog.position(newLogBuffer.getFileChannelPosition());
        this.msgLog.logMessage("Rotate: old log scanned, newLog @ pos=" + newLog.position(), true);
        newLog.force(false);
        this.releaseCurrentLogFile();
        this.setActiveLog(newActiveLog);
        if (this.keepLogs) {
            this.renameLogFileToRightVersion(currentLogFile, endPosition);
        } else {
            this.deleteLogFile(currentLogFile);
        }
        this.xaTf.getAndSetNewVersion();
        this.logVersion = this.xaTf.getCurrentVersion();
        if (this.xaTf.getCurrentVersion() != currentVersion + 1L) {
            throw new IOException("version change failed");
        }
        this.fileChannel = newLog;
        this.positionCache.putHeader(this.logVersion, lastTx);
        this.instantiateCorrectWriteBuffer();
        this.msgLog.logMessage("Log rotated, newLog @ pos=" + this.writeBuffer.getFileChannelPosition() + ", version " + this.logVersion + " and last tx " + this.previousLogLastCommittedTx, true);
        return lastTx;
    }

    private void copyPartiallyWrittenTransactionsToTheNewLog(LogBuffer newLogBuffer) throws IOException {
        boolean foundFirstActiveTx = false;
        HashMap<Integer, LogEntry.Start> startEntriesEncountered = new HashMap<Integer, LogEntry.Start>();
        LogEntry entry = null;
        while ((entry = LogIoUtils.readEntry(this.sharedBuffer, this.fileChannel, this.cf)) != null) {
            boolean isActive;
            Integer identifier = entry.getIdentifier();
            boolean bl = isActive = this.xidIdentMap.get(identifier) != null;
            if (!foundFirstActiveTx && isActive) {
                foundFirstActiveTx = true;
            }
            if (!foundFirstActiveTx) continue;
            if (entry instanceof LogEntry.Start) {
                LogEntry.Start startEntry = (LogEntry.Start)entry;
                startEntriesEncountered.put(identifier, startEntry);
                startEntry.setStartPosition(newLogBuffer.getFileChannelPosition());
                if (isActive) {
                    this.xidIdentMap.put(identifier, startEntry);
                }
            } else if (entry instanceof LogEntry.Commit) {
                LogEntry.Commit commitEntry = (LogEntry.Commit)entry;
                LogEntry.Start startEntry = (LogEntry.Start)startEntriesEncountered.get(identifier);
                if (startEntry == null) {
                    startEntry = this.fetchTransactionBulkFromLogExtractor(commitEntry.getTxId(), newLogBuffer);
                    startEntriesEncountered.put(identifier, startEntry);
                } else {
                    LogExtractor.TxPosition oldPos = this.positionCache.getStartPosition(commitEntry.getTxId());
                    LogExtractor.TxPosition newPos = this.cacheTxStartPosition(commitEntry.getTxId(), startEntry, this.logVersion + 1L);
                    this.msgLog.logMessage("Updated tx " + ((LogEntry.Commit)entry).getTxId() + " from " + oldPos + " to " + newPos);
                }
            }
            if (!startEntriesEncountered.containsKey(identifier)) continue;
            LogIoUtils.writeLogEntry(entry, newLogBuffer);
        }
    }

    private LogEntry.Start fetchTransactionBulkFromLogExtractor(long txId, LogBuffer target) throws IOException {
        LogExtractor extractor = new LogExtractor(this.positionCache, this, this.cf, txId, txId);
        InMemoryLogBuffer tempBuffer = new InMemoryLogBuffer();
        extractor.extractNext(tempBuffer);
        ByteBuffer localBuffer = LogExtractor.newLogReaderBuffer();
        LogEntry readEntry = null;
        while ((readEntry = LogIoUtils.readEntry(localBuffer, tempBuffer, this.cf)) != null && !(readEntry instanceof LogEntry.Commit)) {
            LogIoUtils.writeLogEntry(readEntry, target);
        }
        return extractor.getLastStartEntry();
    }

    private void assertFileDoesntExist(String file, String description) throws IOException {
        if (this.fileSystem.fileExists(file)) {
            throw new IOException(description + ": " + file + " already exist");
        }
    }

    private long getFirstStartEntry(long endPosition) {
        long firstEntryPosition = endPosition;
        for (LogEntry.Start entry : this.xidIdentMap.values()) {
            if (entry.getStartPosition() <= 0L || entry.getStartPosition() >= firstEntryPosition) continue;
            firstEntryPosition = entry.getStartPosition();
        }
        return firstEntryPosition;
    }

    private void setActiveLog(char c) throws IOException {
        if (c != 'C' && c != '1' && c != '2') {
            throw new IllegalArgumentException("Log must be either clean, 1 or 2");
        }
        if (c == this.currentLog) {
            throw new IllegalStateException("Log should not be equal to current " + this.currentLog);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[4]);
        bb.asCharBuffer().put(c).flip();
        FileChannel fc = this.fileSystem.open(this.fileName + ".active", "rw");
        int wrote = fc.write(bb);
        if (wrote != 4) {
            throw new IllegalStateException("Expected to write 4 -> " + wrote);
        }
        fc.force(false);
        fc.close();
        this.currentLog = c;
    }

    public void setKeepLogs(boolean keep) {
        this.keepLogs = keep;
    }

    private boolean hasPreviousLogs() {
        File fileNameFile = new File(this.fileName);
        File logDirectory = fileNameFile.getParentFile();
        if (!logDirectory.exists()) {
            return false;
        }
        Pattern logFilePattern = this.getHistoryFileNamePattern();
        for (File file : logDirectory.listFiles()) {
            if (!logFilePattern.matcher(file.getName()).find()) continue;
            return true;
        }
        return false;
    }

    public boolean isLogsKept() {
        return this.keepLogs;
    }

    public void setAutoRotateLogs(boolean autoRotate) {
        this.autoRotate = autoRotate;
    }

    public boolean isLogsAutoRotated() {
        return this.autoRotate;
    }

    public void setLogicalLogTargetSize(long size) {
        this.rotateAtSize = size;
    }

    public long getLogicalLogTargetSize() {
        return this.rotateAtSize;
    }

    public String getFileName(long version) {
        return this.fileName + ".v" + version;
    }

    public String getBaseFileName() {
        return this.fileName;
    }

    public Pattern getHistoryFileNamePattern() {
        return XaLogicalLog.getHistoryFileNamePattern(new File(this.fileName).getName());
    }

    public static Pattern getHistoryFileNamePattern(String baseFileName) {
        return Pattern.compile(baseFileName + "\\.v\\d+");
    }

    public static long getHistoryLogVersion(File historyLogFile) {
        String toFind;
        String name = historyLogFile.getName();
        int index = name.lastIndexOf(toFind = ".v");
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + historyLogFile + "'");
        }
        return Integer.parseInt(name.substring(index + toFind.length()));
    }

    public static long getHighestHistoryLogVersion(File storeDir, String baseFileName) {
        Pattern logFilePattern = XaLogicalLog.getHistoryFileNamePattern(baseFileName);
        long highest = -1L;
        for (File file : storeDir.listFiles()) {
            if (!logFilePattern.matcher(file.getName()).matches()) continue;
            highest = Math.max(highest, XaLogicalLog.getHistoryLogVersion(file));
        }
        return highest;
    }

    public boolean wasNonClean() {
        return this.nonCleanShutdown;
    }

    @Override
    public long getHighestLogVersion() {
        return this.logVersion;
    }

    protected class LogDeserializer {
        private final ReadableByteChannel byteChannel;
        LogEntry.Start startEntry;
        LogEntry.Commit commitEntry;
        private final List<LogEntry> logEntries;

        protected LogDeserializer(ReadableByteChannel byteChannel) {
            this.byteChannel = byteChannel;
            this.logEntries = new LinkedList<LogEntry>();
        }

        public boolean readAndWriteAndApplyEntry(int newXidIdentifier) throws IOException {
            LogEntry entry = LogIoUtils.readEntry(XaLogicalLog.this.sharedBuffer, this.byteChannel, XaLogicalLog.this.cf);
            if (entry == null) {
                try {
                    this.intercept(this.logEntries);
                    this.apply();
                    return false;
                }
                catch (Error e) {
                    this.startEntry = null;
                    this.commitEntry = null;
                    throw e;
                }
            }
            entry.setIdentifier(newXidIdentifier);
            this.logEntries.add(entry);
            if (entry instanceof LogEntry.Commit) {
                assert (this.startEntry != null);
                this.commitEntry = (LogEntry.Commit)entry;
            } else if (entry instanceof LogEntry.Start) {
                this.startEntry = (LogEntry.Start)entry;
            }
            return true;
        }

        protected void intercept(List<LogEntry> logEntries) {
        }

        private void apply() throws IOException {
            for (LogEntry entry : this.logEntries) {
                if (entry instanceof LogEntry.Start) {
                    ((LogEntry.Start)entry).setStartPosition(XaLogicalLog.this.writeBuffer.getFileChannelPosition());
                    XaLogicalLog.this.applyEntry(entry);
                    LogIoUtils.writeLogEntry(entry, XaLogicalLog.this.writeBuffer);
                    continue;
                }
                LogIoUtils.writeLogEntry(entry, XaLogicalLog.this.writeBuffer);
                if (entry instanceof LogEntry.Commit) {
                    XaLogicalLog.this.writeBuffer.writeOut();
                }
                XaLogicalLog.this.applyEntry(entry);
            }
        }

        protected LogEntry.Start getStartEntry() {
            return this.startEntry;
        }

        protected LogEntry.Commit getCommitEntry() {
            return this.commitEntry;
        }
    }
}

