/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterator;

public class FilteringIterable<T>
implements Iterable<T> {
    private final Iterable<T> source;
    private final Predicate<T> predicate;
    private static final Predicate NOT_NULL_PREDICATE = new Predicate(){

        public boolean accept(Object item) {
            return item != null;
        }
    };

    public FilteringIterable(Iterable<T> source, Predicate<T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteringIterator<T>(this.source.iterator(), this.predicate);
    }

    public static <T> Iterable<T> notNull(Iterable<T> source) {
        return new FilteringIterable<T>(source, FilteringIterable.<T>notNullPredicate());
    }

    public static <T> Iterable<T> noDuplicates(Iterable<T> source) {
        return new FilteringIterable<T>(source, FilteringIterable.<T>noDuplicatesPredicate());
    }

    public static <T> Predicate<T> noDuplicatesPredicate() {
        return new Predicate<T>(){
            private final Set<T> visitedItems = new HashSet();

            @Override
            public boolean accept(T item) {
                return this.visitedItems.add(item);
            }
        };
    }

    public static <T> Predicate<T> notNullPredicate() {
        return NOT_NULL_PREDICATE;
    }
}

